/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.xml.transformers;

import org.custommonkey.xmlunit.XMLUnit;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.mule.functional.junit4.FlowRunner;
import org.mule.functional.junit4.FunctionalTestCase;
import org.mule.runtime.core.api.Event;
import org.mule.runtime.module.xml.util.XMLTestUtils;

public class XsltWithXmlParamsTestCase
extends FunctionalTestCase {
    private static final String EXPECTED = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><result><body><just>testing</just></body><fromParam>value element</fromParam></result>";

    protected String getConfigFile() {
        return "xslt-with-xml-param-config.xml";
    }

    @Test
    public void xmlSourceParam() throws Exception {
        Event event = ((FlowRunner)((FlowRunner)this.flowRunner("xmlSourceParam").withPayload((Object)XMLTestUtils.toSource("simple.xml"))).withVariable("xml", (Object)XMLTestUtils.toSource("test.xml"))).run();
        this.assertExpected(event);
    }

    @Test
    public void xmlStringParam() throws Exception {
        Event event = ((FlowRunner)((FlowRunner)this.flowRunner("xmlStringParam").withPayload((Object)XMLTestUtils.toSource("simple.xml"))).withVariable("xml", (Object)XMLTestUtils.toSource("test.xml"))).run();
        this.assertExpected(event);
    }

    private void assertExpected(Event event) throws Exception {
        Assert.assertThat((Object)XMLUnit.compareXML((String)event.getMessage().getPayload().getValue().toString(), (String)EXPECTED).similar(), (Matcher)CoreMatchers.is((Object)true));
    }
}

