/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.xml.stax;

import javax.xml.namespace.QName;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mule.runtime.module.xml.stax.ReversibleXMLStreamReader;
import org.mule.tck.junit4.AbstractMuleTestCase;

public class ReversibleXMLStreamReaderTest
extends AbstractMuleTestCase {
    private JaxpStreamReaderAsserter asserter = null;

    @Before
    public void setUp() throws Exception {
        String factoryName = XMLInputFactory.newInstance().getClass().getName();
        if (factoryName.equals("com.sun.xml.internal.stream.XMLInputFactoryImpl")) {
            this.asserter = new JaxpStreamReaderAsserter();
        } else if (factoryName.equals("com.ctc.wstx.stax.WstxInputFactory")) {
            this.asserter = new StaxStreamReaderAsserter();
        } else {
            Assert.fail((String)("Don't know how to handle XMLInputFactory \"" + factoryName + "\""));
        }
    }

    @Test
    public void testReverse() throws Exception {
        ReversibleXMLStreamReader xsr = this.createReader();
        this.asserter.assertDocumentStart((XMLStreamReader)xsr);
        QName start = xsr.getName();
        Assert.assertEquals((long)4L, (long)xsr.next());
        String text = xsr.getText();
        xsr.reset();
        Assert.assertEquals((long)1L, (long)xsr.next());
        Assert.assertEquals((Object)start, (Object)xsr.getName());
        Assert.assertEquals((Object)start.getPrefix(), (Object)xsr.getPrefix());
        Assert.assertEquals((Object)start.getLocalPart(), (Object)xsr.getLocalName());
        Assert.assertEquals((Object)start.getNamespaceURI(), (Object)xsr.getNamespaceURI());
        Assert.assertEquals((long)4L, (long)xsr.next());
        Assert.assertEquals((Object)text, (Object)xsr.getText());
        Assert.assertEquals((long)2L, (long)xsr.next());
        this.asserter.assertDocumentEnd((XMLStreamReader)xsr);
        xsr.reset();
        Assert.assertEquals((long)1L, (long)xsr.next());
        Assert.assertEquals((Object)start, (Object)xsr.getName());
        Assert.assertEquals((long)4L, (long)xsr.next());
        Assert.assertEquals((Object)text, (Object)xsr.getText());
        Assert.assertEquals((long)2L, (long)xsr.next());
        Assert.assertEquals((long)8L, (long)xsr.next());
    }

    @Test
    public void testFullReverse() throws Exception {
        ReversibleXMLStreamReader xsr = this.createReader();
        this.asserter.assertDocumentStart((XMLStreamReader)xsr);
        Assert.assertEquals((long)4L, (long)xsr.next());
        Assert.assertEquals((long)2L, (long)xsr.next());
        this.asserter.assertDocumentEnd((XMLStreamReader)xsr);
        xsr.reset();
        Assert.assertEquals((long)1L, (long)xsr.next());
        Assert.assertEquals((long)4L, (long)xsr.next());
        Assert.assertEquals((long)2L, (long)xsr.next());
        Assert.assertEquals((long)8L, (long)xsr.next());
    }

    private ReversibleXMLStreamReader createReader() throws Exception {
        XMLInputFactory xif = XMLInputFactory.newInstance();
        XMLStreamReader coreReader = xif.createXMLStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("/simple.xml"));
        ReversibleXMLStreamReader xsr = new ReversibleXMLStreamReader(coreReader);
        xsr.setTracking(true);
        return xsr;
    }

    private static class StaxStreamReaderAsserter
    extends JaxpStreamReaderAsserter {
        private StaxStreamReaderAsserter() {
        }

        @Override
        public void assertDocumentStart(XMLStreamReader xsr) throws XMLStreamException {
            Assert.assertEquals((long)1L, (long)xsr.next());
        }

        @Override
        public void assertDocumentEnd(XMLStreamReader xsr) throws XMLStreamException {
            Assert.assertEquals((long)8L, (long)xsr.next());
        }
    }

    private static class JaxpStreamReaderAsserter {
        private JaxpStreamReaderAsserter() {
        }

        public void assertDocumentStart(XMLStreamReader xsr) throws XMLStreamException {
            Assert.assertEquals((long)1L, (long)xsr.next());
        }

        public void assertDocumentEnd(XMLStreamReader xsr) throws XMLStreamException {
            Assert.assertEquals((long)8L, (long)xsr.next());
        }
    }
}

