/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.xml.filters;

import java.io.InputStream;
import java.util.HashMap;
import javax.xml.parsers.DocumentBuilderFactory;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Answers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.stubbing.Answer;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.core.api.Event;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.message.InternalMessage;
import org.mule.runtime.core.api.registry.MuleRegistry;
import org.mule.runtime.module.xml.filters.XPathFilter;
import org.mule.runtime.module.xml.xpath.SaxonXpathEvaluator;
import org.mule.runtime.module.xml.xpath.XPathEvaluator;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.size.SmallTest;
import org.mule.tck.util.MuleContextUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

@SmallTest
@RunWith(value=MockitoJUnitRunner.class)
public class XPathFilterTestCase
extends AbstractMuleTestCase {
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    private MuleContext muleContext;
    private SaxonXpathEvaluator xpathManager;
    private XPathFilter filter;

    @Before
    public void before() throws Exception {
        this.xpathManager = new SaxonXpathEvaluator();
        Mockito.when((Object)this.muleContext.getRegistry()).thenReturn(Mockito.mock(MuleRegistry.class, (Answer)Mockito.RETURNS_DEFAULTS));
        this.filter = new XPathFilter();
        this.filter.setMuleContext(this.muleContext);
        this.filter.setXpathEvaluator((XPathEvaluator)this.xpathManager);
    }

    @Test
    public void testAcceptMessage() throws Exception {
        final Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
        XPathFilter filter = new XPathFilter(){

            public Node toDOMNode(Object src) throws Exception {
                return document;
            }

            protected boolean accept(Node node) {
                return node == document;
            }
        };
        Event.Builder builder = Event.builder((Event)this.nullPayloadEvent());
        Assert.assertFalse((String)"shouldn't accept a message if no payload is set.", (boolean)filter.accept(this.nullPayloadEvent(), builder));
        Event event = MuleContextUtils.eventBuilder().message((Message)InternalMessage.of((Object)new Object())).build();
        filter.setPattern("/some/pattern = null");
        builder = Event.builder((Event)event);
        Assert.assertTrue((boolean)filter.accept(event, builder));
        Assert.assertEquals((Object)"null", (Object)filter.getExpectedValue());
        Assert.assertEquals((Object)"/some/pattern", (Object)filter.getPattern().trim());
        Assert.assertSame((Object)document, (Object)builder.build().getMessage().getPayload().getValue());
        event = MuleContextUtils.eventBuilder().message((Message)InternalMessage.of((Object)new Object())).build();
        builder = Event.builder((Event)event);
        filter.setExpectedValue(null);
        Assert.assertTrue((boolean)filter.accept(event, builder));
        Assert.assertEquals((Object)"true", (Object)filter.getExpectedValue());
        Assert.assertEquals((Object)"/some/pattern", (Object)filter.getPattern().trim());
        Assert.assertSame((Object)document, (Object)builder.build().getMessage().getPayload().getValue());
    }

    @Test
    public void testAcceptNode() throws Exception {
        InputStream testXml = ((Object)((Object)this)).getClass().getResourceAsStream("/test.xml");
        Assert.assertNotNull((Object)testXml);
        this.filter.setPattern("/some/unknown/path");
        this.filter.setExpectedValue("bogus");
        this.filter.initialise();
        DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
        builderFactory.setNamespaceAware(true);
        Document document = builderFactory.newDocumentBuilder().parse(testXml);
        Assert.assertFalse((String)"shouldn't have accepted a null evaluation when expected value isn't null.", (boolean)this.filter.accept((Node)document));
        this.filter.setExpectedValue("null");
        Assert.assertTrue((boolean)this.filter.accept((Node)document));
        this.filter.setPattern("test/some/in");
        Assert.assertFalse((boolean)this.filter.accept((Node)document));
        this.filter.setExpectedValue("another");
        Assert.assertTrue((boolean)this.filter.accept((Node)document));
    }

    @Test
    public void testAcceptSoapNode() throws Exception {
        InputStream soapEnvelope = ((Object)((Object)this)).getClass().getResourceAsStream("/request.xml");
        Assert.assertNotNull((Object)soapEnvelope);
        this.filter.setPattern("/soap:Envelope/soap:Body/mule:echo/mule:echo");
        this.filter.setExpectedValue("Hello!");
        HashMap<String, String> prefix2Namespace = new HashMap<String, String>();
        prefix2Namespace.put("soap", "http://schemas.xmlsoap.org/soap/envelope/");
        prefix2Namespace.put("mule", "http://simple.component.mule.org/");
        this.filter.setNamespaces(prefix2Namespace);
        this.filter.initialise();
        DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
        builderFactory.setNamespaceAware(true);
        Document envDoc = builderFactory.newDocumentBuilder().parse(soapEnvelope);
        Assert.assertTrue((boolean)this.filter.accept((Node)envDoc));
    }
}

