/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.xml.filters;

import java.io.InputStream;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mule.runtime.core.api.Event;
import org.mule.runtime.core.api.message.InternalMessage;
import org.mule.runtime.core.util.IOUtils;
import org.mule.runtime.module.xml.filters.IsXmlFilter;
import org.mule.runtime.module.xml.util.XMLTestUtils;
import org.mule.tck.junit4.AbstractMuleTestCase;

public class IsXmlFilterTestCase
extends AbstractMuleTestCase {
    private IsXmlFilter filter;

    @Before
    public void setUp() {
        this.filter = new IsXmlFilter();
    }

    @Test
    public void testFilterFalse() throws Exception {
        Assert.assertFalse((boolean)this.filter.accept(InternalMessage.builder().payload((Object)"This is definitely not XML.").build(), (Event.Builder)Mockito.mock(Event.Builder.class)));
    }

    @Test
    public void testFilterFalse2() throws Exception {
        Assert.assertFalse((boolean)this.filter.accept(InternalMessage.builder().payload((Object)"<line>This is almost XML</line><line>This is almost XML</line>").build(), (Event.Builder)Mockito.mock(Event.Builder.class)));
    }

    @Test
    public void testFilterTrue() throws Exception {
        Assert.assertTrue((boolean)this.filter.accept(InternalMessage.builder().payload((Object)"<msg attrib=\"att1\">This is some nice XML!</msg>").build(), (Event.Builder)Mockito.mock(Event.Builder.class)));
    }

    @Test
    public void testFilterBytes() throws Exception {
        byte[] bytes = "<msg attrib=\"att1\">This is some nice XML!</msg>".getBytes();
        Assert.assertTrue((boolean)this.filter.accept(InternalMessage.builder().payload((Object)bytes).build(), (Event.Builder)Mockito.mock(Event.Builder.class)));
    }

    @Test
    public void testFilterNull() throws Exception {
        Assert.assertFalse((boolean)this.filter.accept(InternalMessage.builder().nullPayload().build(), (Event.Builder)Mockito.mock(Event.Builder.class)));
    }

    @Test
    public void testFilterLargeXml() throws Exception {
        InputStream is = IOUtils.getResourceAsStream((String)"cdcatalog.xml", ((Object)((Object)this)).getClass());
        Assert.assertNotNull((String)"Test resource not found.", (Object)is);
        String xml = IOUtils.toString((InputStream)is);
        Assert.assertTrue((boolean)this.filter.accept(InternalMessage.builder().payload((Object)xml).build(), (Event.Builder)Mockito.mock(Event.Builder.class)));
    }

    @Test
    public void testFilterLargeXmlCompliantHtml() throws Exception {
        InputStream is = IOUtils.getResourceAsStream((String)"cdcatalog.html", ((Object)((Object)this)).getClass());
        Assert.assertNotNull((String)"Test resource not found.", (Object)is);
        String html = IOUtils.toString((InputStream)is);
        Assert.assertTrue((boolean)this.filter.accept(InternalMessage.builder().payload((Object)html).build(), (Event.Builder)Mockito.mock(Event.Builder.class)));
    }

    @Test
    public void testFilterXmlMessageVariants() throws Exception {
        List<?> list = XMLTestUtils.getXmlMessageVariants("cdcatalog.xml");
        for (Object message : list) {
            Assert.assertTrue((boolean)this.filter.accept(InternalMessage.builder().payload(message).build(), (Event.Builder)Mockito.mock(Event.Builder.class)));
        }
    }
}

