/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.xml.el;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.mule.functional.junit4.FlowRunner;
import org.mule.functional.junit4.FunctionalTestCase;
import org.mule.runtime.core.api.Event;
import org.mule.runtime.core.util.IOUtils;
import org.mule.runtime.module.xml.xpath.XPathReturnType;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XPath3TestCase
extends FunctionalTestCase {
    private static final String HANDKERCHIEF = "handkerchief";
    private static final String FOR_THE_SAME_HANDKERCHIEF = "For the same handkerchief?";
    private static final Double LINES_COUNT = 3556.0;

    protected String getConfigFile() {
        return "xpath3-config.xml";
    }

    @Test
    public void findLinesWithParameterAsString() throws Exception {
        Object lines = this.findLines(HANDKERCHIEF, XPathReturnType.STRING);
        Assert.assertThat((Object)lines, (Matcher)CoreMatchers.instanceOf(String.class));
        Assert.assertThat((Object)((String)lines), (Matcher)CoreMatchers.equalTo((Object)FOR_THE_SAME_HANDKERCHIEF));
    }

    @Test
    public void findLinesWithParameterAsNode() throws Exception {
        Object lines = this.findLines(HANDKERCHIEF, XPathReturnType.NODE);
        Assert.assertThat((Object)lines, (Matcher)CoreMatchers.instanceOf(Node.class));
        Assert.assertThat((Object)((Node)lines).getTextContent(), (Matcher)CoreMatchers.equalTo((Object)FOR_THE_SAME_HANDKERCHIEF));
    }

    @Test
    public void findLinesWithParameterAsNodeList() throws Exception {
        Object lines = this.findLines(HANDKERCHIEF, XPathReturnType.NODESET);
        Assert.assertThat((Object)lines, (Matcher)CoreMatchers.instanceOf(NodeList.class));
        NodeList list = (NodeList)lines;
        Assert.assertThat((Object)list.getLength(), (Matcher)CoreMatchers.is((Object)27));
        Assert.assertThat((Object)list.item(0).getTextContent(), (Matcher)CoreMatchers.equalTo((Object)FOR_THE_SAME_HANDKERCHIEF));
    }

    @Test
    public void findLinesWithParameterAsBoolean() throws Exception {
        Object lines = this.findLines(HANDKERCHIEF, XPathReturnType.BOOLEAN);
        Assert.assertThat((Object)lines, (Matcher)CoreMatchers.instanceOf(Boolean.class));
        Assert.assertThat((Object)((Boolean)lines), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void findLinesWithParameterAsNumber() throws Exception {
        Object lines = this.findLines(HANDKERCHIEF, XPathReturnType.NUMBER);
        Assert.assertThat((Object)lines, (Matcher)CoreMatchers.instanceOf(Double.class));
        Assert.assertThat((Object)((Double)lines), (Matcher)CoreMatchers.is((Object)Double.NaN));
    }

    @Test
    public void concatOverResultNode() throws Exception {
        Node line = (Node)this.findLines(HANDKERCHIEF, XPathReturnType.NODE);
        String result = this.getPayloadAsString(((FlowRunner)this.flowRunner("actTitles").withPayload((Object)line)).run().getMessage());
        Assert.assertThat((Object)result, (Matcher)CoreMatchers.equalTo((Object)"ACT III SCENE III.  The garden of the castle."));
    }

    @Test
    public void getAncestorOverResultNode() throws Exception {
        Node line = (Node)this.findLines(HANDKERCHIEF, XPathReturnType.NODE);
        String result = this.getPayloadAsString(((FlowRunner)this.flowRunner("findSpeaker").withPayload((Object)line)).run().getMessage());
        Assert.assertThat((Object)result, (Matcher)CoreMatchers.equalTo((Object)"EMILIA"));
    }

    @Test
    public void countLines() throws Exception {
        Object result = ((FlowRunner)this.flowRunner("countLines").withPayload((Object)this.getOthello())).run().getMessage().getPayload().getValue();
        Assert.assertThat((Object)result, (Matcher)CoreMatchers.instanceOf(Double.class));
        Assert.assertThat((Object)((Double)result), (Matcher)CoreMatchers.equalTo((Object)LINES_COUNT));
    }

    @Test
    public void payloadConsumed() throws Exception {
        Event event = ((FlowRunner)this.flowRunner("payloadConsumed").withPayload((Object)this.getOthello())).run();
        Assert.assertThat((Object)((String)event.getVariable("result").getValue()), (Matcher)CoreMatchers.equalTo((Object)"3556"));
        Assert.assertThat((Object)event.getMessage().getPayload().getValue(), (Matcher)CoreMatchers.instanceOf(Node.class));
    }

    @Test
    public void foreach() throws Exception {
        ArrayList nodes = new ArrayList();
        ((FlowRunner)((FlowRunner)this.flowRunner("foreach").withPayload((Object)this.getOthello())).withVariable("nodes", nodes)).run();
        Assert.assertThat((Object)nodes.size(), (Matcher)CoreMatchers.is((Object)LINES_COUNT.intValue()));
    }

    private Object findLines(String word, XPathReturnType type) throws Exception {
        return ((FlowRunner)((FlowRunner)((FlowRunner)this.flowRunner("shakespeareLines").withPayload((Object)this.getOthello())).withVariable("word", (Object)word)).withVariable("returnType", (Object)type.name())).run().getMessage().getPayload().getValue();
    }

    private InputStream getOthello() throws IOException {
        return IOUtils.getResourceAsStream((String)"othello.xml", ((Object)((Object)this)).getClass());
    }
}

