/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.xml.el;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.core.api.Event;
import org.mule.runtime.core.api.expression.ExpressionRuntimeException;
import org.mule.runtime.core.api.message.InternalMessage;
import org.mule.runtime.core.el.context.AbstractELTestCase;
import org.mule.runtime.module.xml.xpath.XPathReturnType;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class XPath3FunctionTestCase
extends AbstractELTestCase {
    private static final String ROOT_FOO_BAR = "<root foo=\"bar\"/>";
    private static final String BAR = "bar";

    public XPath3FunctionTestCase(String optimizer) {
        super(optimizer);
    }

    @Test
    public void fromString() throws Exception {
        this.evaluateFooFromPayload(ROOT_FOO_BAR);
        this.evaluateFooFromFlowVar(ROOT_FOO_BAR);
    }

    @Test
    public void fromStream() throws Exception {
        InputStream payload = (InputStream)Mockito.spy((Object)new ByteArrayInputStream(ROOT_FOO_BAR.getBytes()));
        this.evaluateFooFromPayload(payload);
        ((InputStream)Mockito.verify((Object)payload)).close();
        payload = new ByteArrayInputStream(ROOT_FOO_BAR.getBytes());
        this.evaluateFooFromFlowVar(payload);
    }

    @Test
    public void messagePayloadChangedWhenPayloadConsumed() throws Exception {
        Event event = XPath3FunctionTestCase.eventBuilder().message((Message)InternalMessage.of((Object)new ByteArrayInputStream(ROOT_FOO_BAR.getBytes()))).build();
        Event.Builder builder = Event.builder((Event)event);
        Assert.assertThat((Object)((String)this.doEvaluate("xpath3('/root/@foo')", event, builder)), (Matcher)CoreMatchers.equalTo((Object)BAR));
        Assert.assertThat((Object)builder.build().getMessage().getPayload().getValue(), (Matcher)CoreMatchers.instanceOf(Node.class));
    }

    @Test
    public void returnTypes() throws Exception {
        HashMap<XPathReturnType, Class<String>> types = new HashMap<XPathReturnType, Class<String>>();
        types.put(XPathReturnType.BOOLEAN, Boolean.class);
        types.put(XPathReturnType.NODE, Node.class);
        types.put(XPathReturnType.NODESET, NodeList.class);
        types.put(XPathReturnType.NUMBER, Double.class);
        types.put(XPathReturnType.STRING, String.class);
        Event event = XPath3FunctionTestCase.eventBuilder().message((Message)InternalMessage.of((Object)ROOT_FOO_BAR)).build();
        for (Map.Entry entry : types.entrySet()) {
            String expression = String.format("xpath3('/root/@foo', payload, '%s')", ((XPathReturnType)entry.getKey()).name());
            Assert.assertThat((Object)this.doEvaluate(expression, event, Event.builder((Event)event)), (Matcher)CoreMatchers.instanceOf((Class)((Class)entry.getValue())));
        }
    }

    @Test(expected=ExpressionRuntimeException.class)
    public void noArgs() throws Exception {
        Event event = XPath3FunctionTestCase.eventBuilder().message((Message)InternalMessage.of((Object)ROOT_FOO_BAR)).build();
        this.doEvaluate("xpath3()", event, Event.builder((Event)event));
    }

    @Test(expected=ExpressionRuntimeException.class)
    public void tooManyArgs() throws Exception {
        Event event = XPath3FunctionTestCase.eventBuilder().message((Message)InternalMessage.of((Object)ROOT_FOO_BAR)).build();
        this.doEvaluate("xpath3('/root/@foo', payload, 'STRING_DATA_TYPE', 'one too many')", event, Event.builder((Event)event));
    }

    @Test(expected=ExpressionRuntimeException.class)
    public void blankExpression() throws Exception {
        Event event = XPath3FunctionTestCase.eventBuilder().message((Message)InternalMessage.of((Object)ROOT_FOO_BAR)).build();
        this.doEvaluate("xpath3('')", event, Event.builder((Event)event));
    }

    @Test(expected=ExpressionRuntimeException.class)
    public void notAStringExpression() throws Exception {
        Event event = XPath3FunctionTestCase.eventBuilder().message((Message)InternalMessage.of((Object)ROOT_FOO_BAR)).build();
        this.doEvaluate("xpath3(System.out)", event, Event.builder((Event)event));
    }

    @Test
    public void fromDom4jDocument() throws Exception {
        Document document = DocumentHelper.parseText((String)ROOT_FOO_BAR);
        this.evaluateFooFromPayload(document);
        this.evaluateFooFromFlowVar(document);
    }

    @Test
    public void fromW3CDocument() throws Exception {
        org.w3c.dom.Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(new InputSource(new StringReader(ROOT_FOO_BAR)));
        this.evaluateFooFromPayload(document);
        this.evaluateFooFromFlowVar(document);
    }

    @Test
    public void fromXmlStreamReader() throws Exception {
        this.evaluateFooFromPayload(this.getXmlStreamReader());
        this.evaluateFooFromFlowVar(this.getXmlStreamReader());
    }

    public XMLStreamReader getXmlStreamReader() throws XMLStreamException {
        return XMLInputFactory.newInstance().createXMLStreamReader(new StringReader(ROOT_FOO_BAR));
    }

    @Test
    public void parametrized() throws Exception {
        Event event = XPath3FunctionTestCase.eventBuilder().message((Message)InternalMessage.of((Object)ROOT_FOO_BAR)).addVariable("foo", (Object)BAR).build();
        Object result = this.doEvaluate("xpath3('/root[@foo=$foo]', payload, 'NODE')", event, Event.builder((Event)event));
        Assert.assertThat((Object)result, (Matcher)CoreMatchers.instanceOf(Node.class));
        Assert.assertThat((Object)((Node)result).getAttributes().getNamedItem("foo").getNodeValue(), (Matcher)CoreMatchers.equalTo((Object)BAR));
    }

    @Test
    public void emptyParametrizedResult() throws Exception {
        Event event = XPath3FunctionTestCase.eventBuilder().message((Message)InternalMessage.of((Object)ROOT_FOO_BAR)).addVariable("foo", (Object)"not a bar").build();
        Object result = this.doEvaluate("xpath3('/root[@foo=$foo]', payload, 'NODE')", event, Event.builder((Event)event));
        Assert.assertThat((Object)result, (Matcher)Is.is((Matcher)CoreMatchers.nullValue()));
    }

    @Test
    public void autoConvertNumericType() throws Exception {
        Event event = XPath3FunctionTestCase.eventBuilder().message((Message)InternalMessage.of((Object)"<root foo=\"33\"/>")).addVariable("foo", (Object)33).build();
        Object result = this.doEvaluate("xpath3('/root[@foo=$foo]', payload, 'NODE')", event, Event.builder((Event)event));
        Assert.assertThat((Object)result, (Matcher)CoreMatchers.instanceOf(Node.class));
        Assert.assertThat((Object)((Node)result).getAttributes().getNamedItem("foo").getNodeValue(), (Matcher)CoreMatchers.equalTo((Object)"33"));
    }

    private void evaluateFooFromPayload(Object payload) throws Exception {
        Event event = XPath3FunctionTestCase.eventBuilder().message((Message)InternalMessage.builder().payload(payload).build()).build();
        Assert.assertThat((Object)((String)this.doEvaluate("xpath3('/root/@foo')", event, Event.builder((Event)event))), (Matcher)CoreMatchers.equalTo((Object)BAR));
    }

    private void evaluateFooFromFlowVar(Object payload) throws Exception {
        Event event = XPath3FunctionTestCase.eventBuilder().message((Message)InternalMessage.of((Object)"")).addVariable("input", payload).build();
        Assert.assertThat((Object)((String)this.doEvaluate("xpath3('/root/@foo', flowVars['input'])", event, Event.builder((Event)event))), (Matcher)CoreMatchers.equalTo((Object)BAR));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object doEvaluate(String expression, Event event, Event.Builder builder) throws Exception {
        Event.setCurrentEvent((Event)event);
        try {
            Object object = this.evaluate(expression, event, builder);
            return object;
        }
        finally {
            Event.setCurrentEvent(null);
        }
    }
}

