/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.xml.transformer;

import java.io.StringReader;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.URIResolver;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.pool.BasePoolableObjectFactory;
import org.apache.commons.pool.PoolableObjectFactory;
import org.apache.commons.pool.impl.GenericObjectPool;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.core.api.DefaultMuleException;
import org.mule.runtime.core.api.Event;
import org.mule.runtime.core.api.message.InternalMessage;
import org.mule.runtime.core.api.transformer.Transformer;
import org.mule.runtime.core.api.transformer.TransformerException;
import org.mule.runtime.core.config.i18n.CoreMessages;
import org.mule.runtime.core.util.ClassUtils;
import org.mule.runtime.core.util.IOUtils;
import org.mule.runtime.core.util.StringUtils;
import org.mule.runtime.module.xml.i18n.XmlMessages;
import org.mule.runtime.module.xml.transformer.AbstractXmlTransformer;
import org.mule.runtime.module.xml.transformer.DelayedResult;
import org.mule.runtime.module.xml.util.LocalURIResolver;
import org.mule.runtime.module.xml.util.XMLUtils;

public class XsltTransformer
extends AbstractXmlTransformer {
    private static final int MIN_IDLE_TRANSFORMERS = 1;
    private static final int MAX_IDLE_TRANSFORMERS = 32;
    private static final int MAX_ACTIVE_TRANSFORMERS = 32;
    public static final String PREFERRED_TRANSFORMER_FACTORY = "net.sf.saxon.TransformerFactoryImpl";
    protected final GenericObjectPool transformerPool = new GenericObjectPool((PoolableObjectFactory)new PooledXsltTransformerFactory());
    private volatile String xslTransformerFactoryClassName = "net.sf.saxon.TransformerFactoryImpl";
    private volatile String xslFile;
    private volatile String xslt;
    private volatile Map<String, Object> contextProperties;
    private URIResolver uriResolver;

    public XsltTransformer() {
        this.transformerPool.setMinIdle(1);
        this.transformerPool.setMaxIdle(32);
        this.transformerPool.setMaxActive(32);
        this.contextProperties = new HashMap<String, Object>();
    }

    @Override
    protected void doInitialise() throws InitialisationException {
        this.logger.debug("Initialising transformer: " + (Object)((Object)this));
        try {
            if (this.xslFile != null) {
                this.xslt = IOUtils.getResourceAsString((String)this.xslFile, ((Object)((Object)this)).getClass());
            }
            if (this.uriResolver == null) {
                this.uriResolver = new LocalURIResolver(this.xslFile);
            }
            this.transformerPool.addObject();
        }
        catch (Throwable te) {
            throw new InitialisationException(te, (Initialisable)this);
        }
    }

    public Object transformMessage(Event event, Charset outputEncoding) throws TransformerException {
        InternalMessage message = event.getMessage();
        Object src = message.getPayload().getValue();
        try {
            Source sourceDoc = XMLUtils.toXmlSource(this.getXMLInputFactory(), this.isUseStaxSource(), src);
            if (sourceDoc == null) {
                return null;
            }
            AbstractXmlTransformer.ResultHolder holder = XsltTransformer.getResultHolder(this.getReturnDataType().getType());
            if (holder == null) {
                holder = XsltTransformer.getResultHolder(src.getClass());
            }
            if (holder == null || DelayedResult.class.equals((Object)this.getReturnDataType().getType())) {
                return this.getDelayedResult(event, outputEncoding, sourceDoc);
            }
            this.doTransform(event, outputEncoding, sourceDoc, holder.getResult());
            return holder.getResultObject();
        }
        catch (Exception e) {
            throw new TransformerException((Transformer)this, (Throwable)e);
        }
    }

    protected Object getDelayedResult(final Event event, final Charset outputEncoding, final Source sourceDoc) {
        return new DelayedResult(){
            private String systemId;

            @Override
            public void write(Result result) throws Exception {
                XsltTransformer.this.doTransform(event, outputEncoding, sourceDoc, result);
            }

            @Override
            public String getSystemId() {
                return this.systemId;
            }

            @Override
            public void setSystemId(String systemId) {
                this.systemId = systemId;
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doTransform(Event event, Charset outputEncoding, Source sourceDoc, Result result) throws Exception {
        DefaultErrorListener errorListener = new DefaultErrorListener((Transformer)this);
        javax.xml.transform.Transformer transformer = null;
        try {
            transformer = (javax.xml.transform.Transformer)this.transformerPool.borrowObject();
            transformer.setErrorListener(errorListener);
            transformer.setOutputProperty("encoding", outputEncoding.name());
            if (this.contextProperties != null) {
                for (Map.Entry<String, Object> parameter : this.contextProperties.entrySet()) {
                    String key = parameter.getKey();
                    Object value = this.evaluateTransformParameter(key, parameter.getValue(), event);
                    if (value != null) {
                        transformer.setParameter(key, value);
                        continue;
                    }
                    throw new DefaultMuleException(XmlMessages.contextPropertyValueIsNull(key));
                }
            }
            transformer.transform(sourceDoc, result);
            if (errorListener.isError()) {
                throw errorListener.getException();
            }
        }
        finally {
            if (transformer != null) {
                this.transformerPool.returnObject((Object)transformer);
            }
        }
    }

    public String getXslTransformerFactory() {
        return this.xslTransformerFactoryClassName;
    }

    public void setXslTransformerFactory(String xslTransformerFactory) {
        this.xslTransformerFactoryClassName = xslTransformerFactory;
    }

    public String getXslFile() {
        return this.xslFile;
    }

    public void setXslFile(String xslFile) {
        this.xslFile = xslFile;
    }

    public String getXslt() {
        return this.xslt;
    }

    public void setXslt(String xslt) {
        this.xslt = xslt;
    }

    public URIResolver getUriResolver() {
        return this.uriResolver;
    }

    public void setUriResolver(URIResolver uriResolver) {
        this.uriResolver = uriResolver;
    }

    protected StreamSource getStreamSource() throws InitialisationException {
        if (this.xslt == null) {
            throw new InitialisationException(CoreMessages.propertiesNotSet((String)"xsl-file or xsl-text"), (Initialisable)this);
        }
        return new StreamSource(new StringReader(this.xslt));
    }

    public int getMaxActiveTransformers() {
        return this.transformerPool.getMaxActive();
    }

    public void setMaxActiveTransformers(int maxActiveTransformers) {
        this.transformerPool.setMaxActive(maxActiveTransformers);
    }

    public int getMaxIdleTransformers() {
        return this.transformerPool.getMaxIdle();
    }

    public void setMaxIdleTransformers(int maxIdleTransformers) {
        this.transformerPool.setMaxIdle(maxIdleTransformers);
    }

    public Map<String, Object> getContextProperties() {
        return this.contextProperties;
    }

    public void setContextProperties(Map<String, Object> contextProperties) {
        this.contextProperties = contextProperties;
    }

    protected Object evaluateTransformParameter(String key, Object value, Event event) throws TransformerException {
        if (value instanceof String) {
            String stringValue = (String)value;
            if (this.muleContext.getExpressionManager().isExpression(stringValue)) {
                return this.muleContext.getExpressionManager().evaluate(stringValue, event).getValue();
            }
        }
        return value;
    }

    protected class DefaultErrorListener
    implements ErrorListener {
        private TransformerException e = null;
        private final Transformer trans;

        public DefaultErrorListener(Transformer trans) {
            this.trans = trans;
        }

        public TransformerException getException() {
            return this.e;
        }

        public boolean isError() {
            return this.e != null;
        }

        @Override
        public void error(javax.xml.transform.TransformerException exception) throws javax.xml.transform.TransformerException {
            this.e = new TransformerException(this.trans, (Throwable)exception);
        }

        @Override
        public void fatalError(javax.xml.transform.TransformerException exception) throws javax.xml.transform.TransformerException {
            this.e = new TransformerException(this.trans, (Throwable)exception);
        }

        @Override
        public void warning(javax.xml.transform.TransformerException exception) throws javax.xml.transform.TransformerException {
            XsltTransformer.this.logger.warn(exception.getMessage());
        }
    }

    protected class PooledXsltTransformerFactory
    extends BasePoolableObjectFactory {
        protected PooledXsltTransformerFactory() {
        }

        public Object makeObject() throws Exception {
            TransformerFactory factory;
            StreamSource source = XsltTransformer.this.getStreamSource();
            String factoryClassName = XsltTransformer.this.getXslTransformerFactory();
            if (XsltTransformer.PREFERRED_TRANSFORMER_FACTORY.equals(factoryClassName) && !ClassUtils.isClassOnPath((String)factoryClassName, ((Object)((Object)this)).getClass())) {
                XsltTransformer.this.logger.warn("Preferred Transfomer Factory net.sf.saxon.TransformerFactoryImpl not on classpath and no default is set, defaulting to JDK");
                factoryClassName = null;
            }
            if (StringUtils.isNotEmpty((String)factoryClassName)) {
                factory = (TransformerFactory)ClassUtils.instanciateClass((String)factoryClassName, (Object[])ClassUtils.NO_ARGS, ((Object)((Object)this)).getClass());
            } else {
                try {
                    factory = TransformerFactory.newInstance();
                }
                catch (TransformerFactoryConfigurationError e) {
                    System.setProperty("javax.xml.transform.TransformerFactory", "com.sun.org.apache.xalan.internal.xsltc.trax.TransformerFactoryImpl");
                    factory = TransformerFactory.newInstance();
                }
            }
            factory.setURIResolver(XsltTransformer.this.getUriResolver());
            return factory.newTransformer(source);
        }

        public void passivateObject(Object object) throws Exception {
            javax.xml.transform.Transformer transformer = (javax.xml.transform.Transformer)object;
            transformer.clearParameters();
            transformer.reset();
            super.passivateObject((Object)transformer);
        }
    }
}

