/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.xml.transformer;

import java.nio.charset.Charset;
import java.util.Map;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.core.api.Event;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.context.MuleContextAware;
import org.mule.runtime.core.api.expression.ExpressionRuntimeException;
import org.mule.runtime.core.api.registry.RegistrationException;
import org.mule.runtime.core.api.transformer.Transformer;
import org.mule.runtime.core.api.transformer.TransformerException;
import org.mule.runtime.core.config.i18n.CoreMessages;
import org.mule.runtime.core.transformer.AbstractTransformer;
import org.mule.runtime.module.xml.util.NamespaceManager;
import org.mule.runtime.module.xml.util.XMLUtils;
import org.mule.runtime.module.xml.xpath.SaxonXpathEvaluator;
import org.mule.runtime.module.xml.xpath.XPathEvaluator;
import org.mule.runtime.module.xml.xpath.XPathReturnType;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;

public class XPathExtractor
extends AbstractTransformer
implements MuleContextAware {
    private XPathEvaluator xpathEvaluator;
    private volatile Map<String, String> prefixToNamespaceMap = null;
    private volatile String expression;
    private volatile XPathReturnType resultType = XPathReturnType.STRING;
    private NamespaceManager namespaceManager;

    public XPathExtractor() {
        this.registerSourceType(DataType.fromType(Node.class));
        this.registerSourceType(DataType.fromType(InputSource.class));
    }

    public void setMuleContext(MuleContext context) {
        this.muleContext = context;
        try {
            this.namespaceManager = (NamespaceManager)this.muleContext.getRegistry().lookupObject(NamespaceManager.class);
        }
        catch (RegistrationException e) {
            throw new ExpressionRuntimeException(CoreMessages.failedToLoad((String)"NamespaceManager"), (Throwable)e);
        }
    }

    public void initialise() throws InitialisationException {
        super.initialise();
        if (this.expression == null) {
            throw new InitialisationException(I18nMessageFactory.createStaticMessage((String)"An expression must be supplied to the StandardXPathExtractor"), (Initialisable)this);
        }
        if (this.xpathEvaluator == null) {
            this.xpathEvaluator = new SaxonXpathEvaluator();
        }
        if (this.namespaceManager != null) {
            this.xpathEvaluator.registerNamespaces(this.namespaceManager);
        }
        if (this.prefixToNamespaceMap != null) {
            this.xpathEvaluator.registerNamespaces(this.prefixToNamespaceMap);
        }
    }

    public Object doTransform(Object src, Charset encoding) throws TransformerException {
        Event event = Event.getCurrentEvent();
        try {
            return this.xpathEvaluator.evaluate(this.expression, XMLUtils.toDOMNode(src, event), this.resultType, event);
        }
        catch (Exception e) {
            throw new TransformerException((Transformer)this, (Throwable)e);
        }
    }

    public String getExpression() {
        return this.expression;
    }

    public void setExpression(String expression) {
        this.expression = expression;
    }

    public XPathReturnType getResultType() {
        return this.resultType;
    }

    public void setResultType(XPathReturnType resultType) {
        this.resultType = resultType;
    }

    public XPathEvaluator getXpathEvaluator() {
        return this.xpathEvaluator;
    }

    public void setXpathEvaluator(XPathEvaluator xpathEvaluator) {
        this.xpathEvaluator = xpathEvaluator;
    }

    public Map<String, String> getNamespaces() {
        return this.prefixToNamespaceMap;
    }

    public void setNamespaces(Map<String, String> prefixToNamespaceMap) {
        this.prefixToNamespaceMap = prefixToNamespaceMap;
    }
}

