/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.xml.transformer;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.Converter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.core.api.transformer.TransformerException;
import org.mule.runtime.core.transformer.AbstractMessageTransformer;
import org.mule.runtime.module.xml.transformer.XStreamFactory;
import org.mule.runtime.module.xml.transformer.datatype.CollectionDataTypeXStreamConverter;
import org.mule.runtime.module.xml.transformer.datatype.SimpleDataTypeXStreamConverter;

public abstract class AbstractXStreamTransformer
extends AbstractMessageTransformer {
    private final AtomicReference<XStream> xstream = new AtomicReference();
    private volatile String driverClass = "com.thoughtworks.xstream.io.xml.XppDriver";
    private volatile Map<String, Class<?>> aliases = new HashMap();
    private volatile Set<Class<? extends Converter>> converters = new HashSet<Class<? extends Converter>>();

    public void initialise() throws InitialisationException {
        super.initialise();
        try {
            this.addConverter(SimpleDataTypeXStreamConverter.class);
            this.addConverter(CollectionDataTypeXStreamConverter.class);
            XStream xStreamInstance = this.getXStream();
            xStreamInstance.setClassLoader(Thread.currentThread().getContextClassLoader());
        }
        catch (TransformerException e) {
            throw new InitialisationException((Throwable)e, (Initialisable)this);
        }
    }

    public final XStream getXStream() throws TransformerException {
        XStream instance = this.xstream.get();
        if (instance == null) {
            try {
                instance = new XStreamFactory(this.driverClass, this.aliases, this.converters).getInstance();
                if (!this.xstream.compareAndSet(null, instance)) {
                    instance = this.xstream.get();
                }
            }
            catch (Exception e) {
                throw new TransformerException(I18nMessageFactory.createStaticMessage((String)"Unable to initialize XStream"), (Throwable)e);
            }
        }
        return instance;
    }

    public Object clone() throws CloneNotSupportedException {
        AbstractXStreamTransformer clone = (AbstractXStreamTransformer)((Object)super.clone());
        clone.setDriverClass(this.driverClass);
        if (this.aliases != null) {
            clone.setAliases(new HashMap(this.aliases));
        }
        if (this.converters != null) {
            clone.setConverters(new HashSet<Class<? extends Converter>>(this.converters));
        }
        return clone;
    }

    public String getDriverClass() {
        return this.driverClass;
    }

    public void setDriverClass(String driverClass) {
        this.driverClass = driverClass;
        this.xstream.set(null);
    }

    public Map<String, Class<?>> getAliases() {
        return this.aliases;
    }

    public void setAliases(Map<String, Class<?>> aliases) {
        this.aliases = aliases;
        this.xstream.set(null);
    }

    public Set<Class<? extends Converter>> getConverters() {
        return this.converters;
    }

    public void setConverters(Set<Class<? extends Converter>> converters) {
        this.converters = converters;
        this.xstream.set(null);
    }

    public void addAlias(String alias, Class<?> aClass) {
        this.aliases.put(alias, aClass);
    }

    public Class<?> removeAlias(String alias) {
        return this.aliases.remove(alias);
    }

    public void addConverter(Class<? extends Converter> converterClass) {
        this.converters.add(converterClass);
    }

    public boolean removeAlias(Class<? extends Converter> converterClass) {
        return this.converters.remove(converterClass);
    }
}

