/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.xml.transformer.jaxb;

import java.io.File;
import java.io.InputStream;
import java.io.StringReader;
import java.io.Writer;
import java.net.URL;
import java.nio.charset.Charset;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.Source;
import javax.xml.transform.sax.SAXSource;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.core.api.transformer.Transformer;
import org.mule.runtime.core.api.transformer.TransformerException;
import org.mule.runtime.core.config.i18n.CoreMessages;
import org.mule.runtime.core.transformer.AbstractTransformer;
import org.mule.runtime.core.util.xmlsecurity.XMLSecureFactories;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;

public class JAXBUnmarshallerTransformer
extends AbstractTransformer {
    protected JAXBContext jaxbContext;

    public JAXBUnmarshallerTransformer() {
        this.registerSourceType(DataType.STRING);
        this.registerSourceType(DataType.fromType(Writer.class));
        this.registerSourceType(DataType.fromType(File.class));
        this.registerSourceType(DataType.fromType(URL.class));
        this.registerSourceType(DataType.fromType(Node.class));
        this.registerSourceType(DataType.INPUT_STREAM);
        this.registerSourceType(DataType.fromType(Source.class));
        this.registerSourceType(DataType.fromType(XMLStreamReader.class));
        this.registerSourceType(DataType.fromType(XMLEventReader.class));
    }

    public JAXBUnmarshallerTransformer(JAXBContext jaxbContext, DataType returnType) {
        this();
        this.jaxbContext = jaxbContext;
        this.setReturnDataType(returnType);
    }

    public void initialise() throws InitialisationException {
        super.initialise();
        if (this.jaxbContext == null) {
            if (Object.class.equals((Object)this.getReturnDataType().getType())) {
                throw new InitialisationException(CoreMessages.objectIsNull((String)"jaxbContext"), (Initialisable)this);
            }
            try {
                this.jaxbContext = JAXBContext.newInstance((Class[])new Class[]{this.getReturnDataType().getType()});
            }
            catch (JAXBException e) {
                throw new InitialisationException((Throwable)e, (Initialisable)this);
            }
        }
    }

    protected Object doTransform(Object src, Charset outputEncoding) throws TransformerException {
        try {
            Unmarshaller u = this.jaxbContext.createUnmarshaller();
            Object result = null;
            if (src instanceof String) {
                SAXParserFactory spf = XMLSecureFactories.createDefault().getSAXParserFactory();
                spf.setNamespaceAware(true);
                SAXSource xmlSource = new SAXSource(spf.newSAXParser().getXMLReader(), new InputSource(new StringReader((String)src)));
                result = u.unmarshal((Source)xmlSource);
            } else if (src instanceof File) {
                result = u.unmarshal((File)src);
            } else if (src instanceof URL) {
                result = u.unmarshal((URL)src);
            } else if (src instanceof InputStream) {
                result = u.unmarshal((InputStream)src);
            } else if (src instanceof Node) {
                result = u.unmarshal((Node)src, this.getReturnDataType().getType());
            } else if (src instanceof Source) {
                result = u.unmarshal((Source)src, this.getReturnDataType().getType());
            } else if (src instanceof XMLStreamReader) {
                result = u.unmarshal((XMLStreamReader)src, this.getReturnDataType().getType());
            } else if (src instanceof XMLEventReader) {
                result = u.unmarshal((XMLEventReader)src, this.getReturnDataType().getType());
            }
            if (result != null && result instanceof JAXBElement) {
                result = ((JAXBElement)result).getValue();
            }
            return result;
        }
        catch (Exception e) {
            throw new TransformerException((Transformer)this, (Throwable)e);
        }
    }

    public JAXBContext getJaxbContext() {
        return this.jaxbContext;
    }

    public void setJaxbContext(JAXBContext jaxbContext) {
        this.jaxbContext = jaxbContext;
    }
}

