/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.xml.filters;

import java.text.MessageFormat;
import java.util.Map;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.core.api.Event;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.context.MuleContextAware;
import org.mule.runtime.core.api.expression.ExpressionRuntimeException;
import org.mule.runtime.core.api.message.InternalMessage;
import org.mule.runtime.core.api.registry.RegistrationException;
import org.mule.runtime.core.api.routing.filter.Filter;
import org.mule.runtime.core.config.i18n.CoreMessages;
import org.mule.runtime.core.util.ClassUtils;
import org.mule.runtime.module.xml.filters.AbstractJaxpFilter;
import org.mule.runtime.module.xml.util.NamespaceManager;
import org.mule.runtime.module.xml.xpath.SaxonXpathEvaluator;
import org.mule.runtime.module.xml.xpath.XPathEvaluator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Node;

public class XPathFilter
extends AbstractJaxpFilter
implements Filter,
Initialisable,
MuleContextAware {
    protected transient Logger logger = LoggerFactory.getLogger(this.getClass());
    private String pattern;
    private String expectedValue;
    private XPathEvaluator xpathEvaluator;
    private Map<String, String> prefixToNamespaceMap = null;
    private NamespaceManager namespaceManager;
    private MuleContext muleContext;

    public XPathFilter() {
    }

    public XPathFilter(String pattern) {
        this.pattern = pattern;
    }

    public XPathFilter(String pattern, String expectedValue) {
        this.pattern = pattern;
        this.expectedValue = expectedValue;
    }

    public void setMuleContext(MuleContext context) {
        this.muleContext = context;
    }

    @Override
    public void initialise() throws InitialisationException {
        super.initialise();
        if (this.xpathEvaluator == null) {
            this.xpathEvaluator = new SaxonXpathEvaluator();
        }
        if (this.pattern == null) {
            throw new InitialisationException(I18nMessageFactory.createStaticMessage((String)("A pattern must be supplied to the " + ClassUtils.getSimpleName(this.getClass()))), (Initialisable)this);
        }
        try {
            this.namespaceManager = (NamespaceManager)this.muleContext.getRegistry().lookupObject(NamespaceManager.class);
        }
        catch (RegistrationException e) {
            throw new ExpressionRuntimeException(CoreMessages.failedToLoad((String)"NamespaceManager"), (Throwable)e);
        }
        if (this.namespaceManager != null) {
            this.xpathEvaluator.registerNamespaces(this.namespaceManager);
        }
        if (this.prefixToNamespaceMap != null) {
            this.xpathEvaluator.registerNamespaces(this.prefixToNamespaceMap);
        }
    }

    public boolean accept(InternalMessage message, Event.Builder builder) {
        throw new UnsupportedOperationException("MULE-9341 Remove Filters that are not needed.  This method will be removed when filters are cleaned up.");
    }

    public boolean accept(Event event, Event.Builder builder) {
        Node node;
        Object payload = event.getMessage().getPayload().getValue();
        if (payload == null) {
            if (this.logger.isWarnEnabled()) {
                this.logger.warn("Applying {} to null object.", (Object)ClassUtils.getSimpleName(this.getClass()));
            }
            return false;
        }
        if (this.pattern == null) {
            if (this.logger.isWarnEnabled()) {
                this.logger.warn("Expression for " + ClassUtils.getSimpleName(this.getClass()) + " is not set.");
            }
            return false;
        }
        if (this.expectedValue == null) {
            if (this.pattern.endsWith("= null") || this.pattern.endsWith("=null")) {
                this.expectedValue = "null";
                this.pattern = this.pattern.substring(0, this.pattern.lastIndexOf("="));
            } else {
                if (this.logger.isInfoEnabled()) {
                    this.logger.info("''expectedValue'' attribute for {} is not set, using 'true' by default", (Object)ClassUtils.getSimpleName(this.getClass()));
                }
                this.expectedValue = Boolean.TRUE.toString();
            }
        }
        try {
            node = this.toDOMNode(payload);
        }
        catch (Exception e) {
            if (this.logger.isWarnEnabled()) {
                this.logger.warn(ClassUtils.getSimpleName(this.getClass()) + " filter rejected message because of an error while parsing XML: " + e.getMessage(), (Throwable)e);
            }
            return false;
        }
        builder.message((Message)InternalMessage.builder((Message)event.getMessage()).payload((Object)node).build());
        return this.accept(node);
    }

    protected boolean accept(Node node) {
        String xpathResult;
        boolean accept = false;
        try {
            xpathResult = this.xpathEvaluator.evaluate(this.pattern, node, Event.getCurrentEvent());
        }
        catch (Exception e) {
            if (this.logger.isWarnEnabled()) {
                this.logger.warn(ClassUtils.getSimpleName(this.getClass()) + " filter rejected message because of an error while evaluating the expression: " + e.getMessage(), (Throwable)e);
            }
            return false;
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(MessageFormat.format("{0} Expression result = ''{1}'' -  Expected value = ''{2}''", ClassUtils.getSimpleName(this.getClass()), xpathResult, this.expectedValue));
        }
        if (xpathResult != null && !"".equals(xpathResult)) {
            accept = xpathResult.toString().equals(this.expectedValue);
        } else if ("null".equals(this.expectedValue)) {
            accept = true;
        } else if (this.logger.isDebugEnabled()) {
            this.logger.debug(MessageFormat.format("{0} expression evaluates to null: {1}", ClassUtils.getSimpleName(this.getClass()), this.pattern));
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(MessageFormat.format("{0} accept object  : {1}", ClassUtils.getSimpleName(this.getClass()), accept));
        }
        return accept;
    }

    public String getPattern() {
        return this.pattern;
    }

    public void setPattern(String pattern) {
        this.pattern = pattern;
    }

    public String getExpectedValue() {
        return this.expectedValue;
    }

    public void setExpectedValue(String expectedValue) {
        this.expectedValue = expectedValue;
    }

    public void setXpathEvaluator(XPathEvaluator xpathEvaluator) {
        this.xpathEvaluator = xpathEvaluator;
    }

    public Map<String, String> getNamespaces() {
        return this.prefixToNamespaceMap;
    }

    public void setNamespaces(Map<String, String> prefixToNamespaceMap) {
        this.prefixToNamespaceMap = prefixToNamespaceMap;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        XPathFilter other = (XPathFilter)obj;
        return ClassUtils.equal((Object)this.expectedValue, (Object)other.expectedValue) && ClassUtils.equal(this.prefixToNamespaceMap, other.prefixToNamespaceMap) && ClassUtils.equal((Object)this.pattern, (Object)other.pattern);
    }

    public int hashCode() {
        return ClassUtils.hash((Object[])new Object[]{this.getClass(), this.expectedValue, this.prefixToNamespaceMap, this.pattern});
    }
}

