/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.module.xml.config;

import org.junit.Assert;
import org.junit.Test;
import org.mule.functional.junit4.MuleArtifactFunctionalTestCase;
import org.mule.jaxb.model.Person;
import org.mule.runtime.core.api.routing.filter.Filter;
import org.mule.runtime.core.api.transformer.Transformer;
import org.mule.runtime.module.xml.filters.SchemaValidationFilter;
import org.mule.runtime.module.xml.transformer.jaxb.JAXBMarshallerTransformer;
import org.mule.runtime.module.xml.transformer.jaxb.JAXBUnmarshallerTransformer;
import org.mule.runtime.module.xml.util.NamespaceManager;
import org.w3c.dom.ls.LSInput;
import org.w3c.dom.ls.LSResourceResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class XmlNamespaceTestCase
extends MuleArtifactFunctionalTestCase {
    public XmlNamespaceTestCase() {
        this.setDisposeContextPerClass(true);
    }

    protected String getConfigFile() {
        return "xml-namespace-config.xml";
    }

    @Test
    public void testGlobalNamespaces() throws Exception {
        NamespaceManager manager = (NamespaceManager)muleContext.getRegistry().lookupObject(NamespaceManager.class);
        Assert.assertNotNull((Object)manager);
        Assert.assertTrue((boolean)manager.isIncludeConfigNamespaces());
        Assert.assertEquals((long)5L, (long)manager.getNamespaces().size());
    }

    @Test
    public void testJaxbConfig() throws Exception {
        JAXBMarshallerTransformer t = (JAXBMarshallerTransformer)this.lookupTransformer("ObjectToXml");
        Assert.assertNotNull((Object)t.getJaxbContext());
        JAXBUnmarshallerTransformer t2 = (JAXBUnmarshallerTransformer)this.lookupTransformer("XmlToObject");
        Assert.assertEquals(Person.class, (Object)t2.getReturnDataType().getType());
        Assert.assertNotNull((Object)t2.getJaxbContext());
    }

    @Test
    public void testSchemaValidationFilterWithCustomResourceResolver() {
        SchemaValidationFilter filter = (SchemaValidationFilter)this.lookupFilter("SchemaValidationWithResourceResolver");
        Assert.assertEquals((Object)"schema1.xsd", (Object)filter.getSchemaLocations());
        Assert.assertTrue((boolean)(filter.getResourceResolver() instanceof MockResourceResolver));
        Assert.assertTrue((boolean)(filter.getErrorHandler() instanceof MockErrorHandler));
        Assert.assertFalse((boolean)filter.isReturnResult());
    }

    private Transformer lookupTransformer(String name) {
        Transformer transformer = muleContext.getRegistry().lookupTransformer(name);
        Assert.assertNotNull((Object)transformer);
        return transformer;
    }

    private Filter lookupFilter(String name) {
        Filter filter = (Filter)muleContext.getRegistry().lookupObject(name);
        Assert.assertNotNull((Object)filter);
        return filter;
    }

    private static class MockErrorHandler
    implements ErrorHandler {
        private MockErrorHandler() {
        }

        @Override
        public void error(SAXParseException exception) throws SAXException {
        }

        @Override
        public void fatalError(SAXParseException exception) throws SAXException {
        }

        @Override
        public void warning(SAXParseException exception) throws SAXException {
        }
    }

    private static class MockResourceResolver
    implements LSResourceResolver {
        private MockResourceResolver() {
        }

        @Override
        public LSInput resolveResource(String type, String namespaceURI, String publicId, String systemId, String baseURI) {
            return null;
        }
    }
}

