/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.xml.util;

import java.io.File;
import java.io.IOException;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.core.IsNot;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.mule.runtime.core.util.UUID;
import org.mule.runtime.module.xml.util.MuleResourceResolver;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.size.SmallTest;
import org.w3c.dom.ls.LSInput;

@SmallTest
public class MuleResourceResolverTestCase
extends AbstractMuleTestCase {
    private static final String NON_EXISTENT_RESOURCE = "non-existent-resource";
    private static final String EXISTENT_CLASSPATH_SUBDIRECTORY = "localresourceresolver";
    private static final String EXISTENT_CLASSPATH_SUBDIRECTORY_RESOURCE = "resource.txt";
    private static final String EXISTENT_CLASSPATH_ABSOLUTE_RESOURCE = "localresourceresolver/resource.txt";
    private static final String IDENTIFIER_TYPE = "myTestType";
    private static final String IDENTIFIER_NAMESPACE = "myTestNameSpace";
    private static final String IDENTIFIER_PUBLIC_ID = "myTestPublicId";
    @Rule
    public TemporaryFolder temporaryFolder = new TemporaryFolder();
    MuleResourceResolver resolver;

    @Before
    public void prepare() {
        this.resolver = new MuleResourceResolver();
    }

    @Test
    public void testsNonExistentResource() {
        LSInput outcome = this.resolver.resolveResource(IDENTIFIER_TYPE, IDENTIFIER_NAMESPACE, IDENTIFIER_PUBLIC_ID, NON_EXISTENT_RESOURCE, null);
        Assert.assertThat((Object)outcome, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
    }

    @Test
    public void testsExistentClasspathResource() {
        LSInput outcome = this.resolver.resolveResource(IDENTIFIER_TYPE, IDENTIFIER_NAMESPACE, IDENTIFIER_PUBLIC_ID, EXISTENT_CLASSPATH_ABSOLUTE_RESOURCE, null);
        Assert.assertThat((Object)outcome, (Matcher)CoreMatchers.is((Matcher)IsNot.not((Matcher)CoreMatchers.nullValue())));
        Assert.assertThat((Object)outcome.getBaseURI(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        this.assertCommon(outcome);
    }

    @Test
    public void testsExistentAbsoluteFileSystemResource() throws IOException {
        File file = this.temporaryFolder.newFile(UUID.getUUID());
        LSInput outcome = this.resolver.resolveResource(IDENTIFIER_TYPE, IDENTIFIER_NAMESPACE, IDENTIFIER_PUBLIC_ID, file.getAbsolutePath(), null);
        Assert.assertThat((Object)outcome, (Matcher)CoreMatchers.is((Matcher)IsNot.not((Matcher)CoreMatchers.nullValue())));
        Assert.assertThat((Object)outcome.getBaseURI(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        this.assertCommon(outcome);
    }

    @Test
    public void testsNonExistentAbsoluteFileSystemResource() throws IOException {
        String nonExistentAbsoluteFileSystemResource = new File(this.temporaryFolder.getRoot(), NON_EXISTENT_RESOURCE).getAbsolutePath();
        LSInput outcome = this.resolver.resolveResource(IDENTIFIER_TYPE, IDENTIFIER_NAMESPACE, IDENTIFIER_PUBLIC_ID, nonExistentAbsoluteFileSystemResource, null);
        Assert.assertThat((Object)outcome, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
    }

    @Test
    public void testsExistentFileSystemResourceWithBaseUri() throws IOException {
        File file = this.temporaryFolder.newFile(UUID.getUUID());
        LSInput outcome = this.resolver.resolveResource(IDENTIFIER_TYPE, IDENTIFIER_NAMESPACE, IDENTIFIER_PUBLIC_ID, file.getName(), file.getPath());
        Assert.assertThat((Object)outcome, (Matcher)CoreMatchers.is((Matcher)IsNot.not((Matcher)CoreMatchers.nullValue())));
        Assert.assertThat((Object)outcome.getBaseURI(), (Matcher)CoreMatchers.is((Matcher)IsNot.not((Matcher)CoreMatchers.nullValue())));
        this.assertCommon(outcome);
    }

    @Test
    public void testsNonExistentFileSystemResourceWithBaseUri() throws IOException {
        File file = this.temporaryFolder.newFile(UUID.getUUID());
        LSInput outcome = this.resolver.resolveResource(IDENTIFIER_TYPE, IDENTIFIER_NAMESPACE, IDENTIFIER_PUBLIC_ID, file.getName(), NON_EXISTENT_RESOURCE);
        Assert.assertThat((Object)outcome, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
    }

    private void assertCommon(LSInput outcome) {
        Assert.assertThat((Object)outcome.getByteStream(), (Matcher)CoreMatchers.is((Matcher)IsNot.not((Matcher)CoreMatchers.nullValue())));
        Assert.assertThat((Object)outcome.getSystemId(), (Matcher)CoreMatchers.is((Matcher)IsNot.not((Matcher)CoreMatchers.nullValue())));
        Assert.assertThat((Object)outcome.getPublicId(), (Matcher)CoreMatchers.is((Object)IDENTIFIER_PUBLIC_ID));
    }
}

