/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.xml.transformers.xml.xstream;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.io.xml.DomDriver;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mule.runtime.core.api.transformer.TransformerException;
import org.mule.runtime.core.util.ClassUtils;
import org.mule.runtime.module.xml.transformer.XmlToObject;
import org.mule.tck.junit4.AbstractMuleTestCase;

public class XStreamTransformerConfigurationTestCase
extends AbstractMuleTestCase {
    public static volatile boolean MyDriverDidInitialize;

    @Before
    public void doSetUp() {
        MyDriverDidInitialize = true;
    }

    @After
    public void doTearDown() {
        MyDriverDidInitialize = false;
    }

    @Test
    public void testDefaultDriver() throws Exception {
        XmlToObject transformer = new XmlToObject();
        Assert.assertEquals((Object)"com.thoughtworks.xstream.io.xml.XppDriver", (Object)transformer.getDriverClass());
    }

    @Test
    public void testCustomDriver() throws Exception {
        XmlToObject transformer = new XmlToObject();
        transformer.setDriverClass(MyDOMDriver.class.getName());
        XStream xs = transformer.getXStream();
        Assert.assertNotNull((Object)xs);
        Assert.assertSame((Object)xs, (Object)transformer.getXStream());
        Assert.assertTrue((boolean)MyDriverDidInitialize);
    }

    @Test
    public void testBadDriver() throws Exception {
        XmlToObject transformer = new XmlToObject();
        transformer.setDriverClass("DudeWhereIsMyDriver");
        try {
            Assert.assertNotNull((Object)transformer.getXStream());
            Assert.fail();
        }
        catch (TransformerException tex) {
            Assert.assertTrue((boolean)(tex.getCause() instanceof ClassNotFoundException));
        }
    }

    @Test
    public void testClassLoader() {
        TestClassLoader classLoader = new TestClassLoader();
        ClassUtils.withContextClassLoader((ClassLoader)classLoader, () -> {
            try {
                XmlToObject transformer = new XmlToObject();
                transformer.initialise();
                Assert.assertEquals((Object)classLoader, (Object)transformer.getXStream().getClassLoader());
            }
            catch (Exception e) {
                Assert.fail((String)e.getMessage());
            }
        });
    }

    private static class TestClassLoader
    extends ClassLoader {
        private TestClassLoader() {
        }
    }

    protected static class MyDOMDriver
    extends DomDriver {
        public MyDOMDriver() {
            MyDriverDidInitialize = true;
        }
    }
}

