/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.xml.transformers.xml.xslt;

import java.io.ByteArrayInputStream;
import junit.framework.Assert;
import org.hamcrest.Matchers;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mule.functional.junit4.FlowRunner;
import org.mule.functional.junit4.FunctionalTestCase;
import org.mule.runtime.core.api.transformer.MessageTransformerException;
import org.mule.runtime.core.exception.MessagingException;
import org.mule.runtime.core.util.IOUtils;

public class XsltTransformerXXETestCase
extends FunctionalTestCase {
    @Rule
    public ExpectedException expectedException = ExpectedException.none();

    protected String getConfigFile() {
        return "xslt-xxe-config.xml";
    }

    @Test
    public void xxeAsStream() throws Exception {
        String input = this.makeInput();
        this.expectedException.expect(MessagingException.class);
        this.expectedException.expectCause(Matchers.instanceOf(MessageTransformerException.class));
        ((FlowRunner)this.flowRunner("safeXxe").withPayload((Object)new ByteArrayInputStream(input.getBytes()))).run().getMessage().getPayload().getValue();
    }

    @Test
    public void xxeAsString() throws Exception {
        String input = this.makeInput();
        this.expectedException.expect(MessagingException.class);
        this.expectedException.expectCause(Matchers.instanceOf(MessageTransformerException.class));
        ((FlowRunner)this.flowRunner("safeXxe").withPayload((Object)input)).run().getMessage().getPayload().getValue();
    }

    @Test
    public void xxeAsByteArray() throws Exception {
        String input = this.makeInput();
        this.expectedException.expect(MessagingException.class);
        this.expectedException.expectCause(Matchers.instanceOf(MessageTransformerException.class));
        ((FlowRunner)this.flowRunner("safeXxe").withPayload((Object)input.getBytes())).run().getMessage().getPayload().getValue();
    }

    @Test
    public void unsafeXxeAsStream() throws Exception {
        String input = this.makeInput();
        this.assertUnsafe(new ByteArrayInputStream(input.getBytes()));
    }

    @Test
    public void unsafeXxeAsString() throws Exception {
        String input = this.makeInput();
        this.assertUnsafe(input);
    }

    @Test
    public void unsafeXxeAsByteArray() throws Exception {
        String input = this.makeInput();
        this.assertUnsafe(input.getBytes());
    }

    private void assertUnsafe(Object payload) throws Exception {
        String output = (String)((FlowRunner)this.flowRunner("unsafeXxe").withPayload(payload)).run().getMessage().getPayload().getValue();
        Assert.assertTrue((boolean)output.contains("secret"));
    }

    private String makeInput() {
        return String.format("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<!DOCTYPE spi_doc_type[ <!ENTITY spi_entity_ref SYSTEM 'file:%s'>]>\n<root>\n<elem>&spi_entity_ref;</elem>\n<something/>\n</root>", IOUtils.getResourceAsUrl((String)"xxe-passwd.txt", ((Object)((Object)this)).getClass()).getPath());
    }
}

