/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.xml.transformers.xml.xslt;

import java.io.InputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamReader;
import org.junit.Assert;
import org.junit.Test;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.core.api.message.InternalMessage;
import org.mule.runtime.core.api.transformer.Transformer;
import org.mule.runtime.core.api.transformer.TransformerException;
import org.mule.runtime.core.util.IOUtils;
import org.mule.runtime.module.xml.transformer.XsltTransformer;
import org.mule.runtime.module.xml.transformers.xml.AbstractXmlTransformerTestCase;
import org.mule.runtime.module.xml.util.XMLTestUtils;
import org.mule.runtime.module.xml.util.XMLUtils;

public class XsltTransformerJDKTransformerTestCase
extends AbstractXmlTransformerTestCase {
    private String srcData;
    private String resultData;

    protected void doSetUp() throws Exception {
        this.srcData = IOUtils.getResourceAsString((String)"cdcatalog.xml", ((Object)((Object)this)).getClass());
        this.resultData = IOUtils.getResourceAsString((String)"cdcatalog.html", ((Object)((Object)this)).getClass());
    }

    public Transformer getTransformer() throws Exception {
        XsltTransformer transformer = new XsltTransformer();
        transformer.setReturnDataType(DataType.STRING);
        transformer.setXslFile("cdcatalog.xsl");
        transformer.setMaxActiveTransformers(42);
        transformer.setXslTransformerFactory(null);
        this.initialiseObject(transformer);
        return transformer;
    }

    public Transformer getRoundTripTransformer() throws Exception {
        return null;
    }

    @Test
    public void testRoundtripTransform() throws Exception {
    }

    public Object getTestData() {
        HashMap<String, Object> props = new HashMap<String, Object>();
        props.put("ListTitle", "MyList");
        props.put("ListRating", new Integer(6));
        return InternalMessage.builder().payload((Object)this.srcData).inboundProperties(props).build();
    }

    public Object getResultData() {
        return this.resultData;
    }

    @Test
    public void testAllXmlMessageTypes() throws Exception {
        List<?> list = XMLTestUtils.getXmlMessageVariants("cdcatalog.xml");
        Iterator<?> it = list.iterator();
        Object expectedResult = this.getResultData();
        Assert.assertNotNull((Object)expectedResult);
        while (it.hasNext()) {
            Object msg = it.next();
            Object result = this.getTransformer().transform(msg);
            Assert.assertNotNull((Object)result);
            Assert.assertTrue((String)("Test failed for message type: " + msg.getClass()), (boolean)this.compareResults(expectedResult, result));
        }
    }

    @Test
    public void testTransformXMLStreamReader() throws Exception {
        Object expectedResult = this.getResultData();
        Assert.assertNotNull((Object)expectedResult);
        XsltTransformer transformer = (XsltTransformer)this.getTransformer();
        InputStream is = IOUtils.getResourceAsStream((String)"cdcatalog.xml", XMLTestUtils.class);
        XMLStreamReader sr = XMLUtils.toXMLStreamReader((XMLInputFactory)transformer.getXMLInputFactory(), (Object)is);
        Object result = transformer.transform((Object)sr);
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((String)("expected: " + expectedResult + "\nresult: " + result), (boolean)this.compareResults(expectedResult, result));
    }

    @Test
    public void testCustomTransformerFactoryClass() throws InitialisationException {
        XsltTransformer t = new XsltTransformer();
        t.setXslTransformerFactory("com.nosuchclass.TransformerFactory");
        t.setXslFile("cdcatalog.xsl");
        try {
            t.initialise();
            Assert.fail((String)"should have failed with ClassNotFoundException");
        }
        catch (InitialisationException iex) {
            Assert.assertEquals(ClassNotFoundException.class, iex.getCause().getClass());
        }
        t = new XsltTransformer();
        t.setXslFile("cdcatalog.xsl");
        t.setXslTransformerFactory(null);
        t.initialise();
    }

    @Test
    public void testTransformWithStaticParam() throws TransformerException, InitialisationException {
        String xml = "<node1><subnode1>sub node 1 original value</subnode1><subnode2>sub node 2 original value</subnode2></node1>";
        String param = "sub node 2 cool new value";
        String expectedTransformedxml = "<node1><subnode1>sub node 1 original value</subnode1><subnode2>" + param + "</subnode2></node1>";
        String xsl = "<xsl:stylesheet xmlns:xsl=\"http://www.w3.org/1999/XSL/Transform\" version=\"2.0\" xmlns:wsdlsoap=\"http://schemas.xmlsoap.org/wsdl/soap/\" xmlns:wsdl=\"http://schemas.xmlsoap.org/wsdl/\"><xsl:param name=\"param1\"/><xsl:template match=\"@*|node()\"><xsl:copy><xsl:apply-templates select=\"@*|node()\"/></xsl:copy></xsl:template><xsl:template match=\"/node1/subnode2/text()\"><xsl:value-of select=\"$param1\"/></xsl:template></xsl:stylesheet>";
        XsltTransformer transformer = new XsltTransformer();
        transformer.setMuleContext(muleContext);
        transformer.setReturnDataType(DataType.STRING);
        transformer.setXslt(xsl);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("param1", param);
        transformer.setContextProperties(params);
        transformer.initialise();
        String transformerResult = (String)transformer.transform((Object)xml);
        transformerResult = transformerResult.substring(transformerResult.indexOf("?>") + 2);
        Assert.assertTrue((transformerResult.indexOf(expectedTransformedxml) > -1 ? 1 : 0) != 0);
    }

    @Test
    public void testTransformWithDynamicParam() throws Exception {
        String xml = "<node1><subnode1>sub node 1 original value</subnode1><subnode2>sub node 2 original value</subnode2></node1>";
        String param = "sub node 2 cool new value";
        String expectedTransformedxml = "<node1><subnode1>sub node 1 original value</subnode1><subnode2>" + param + "</subnode2></node1>";
        String xsl = "<xsl:stylesheet xmlns:xsl=\"http://www.w3.org/1999/XSL/Transform\" version=\"2.0\" xmlns:wsdlsoap=\"http://schemas.xmlsoap.org/wsdl/soap/\" xmlns:wsdl=\"http://schemas.xmlsoap.org/wsdl/\"><xsl:param name=\"param1\"/><xsl:template match=\"@*|node()\"><xsl:copy><xsl:apply-templates select=\"@*|node()\"/></xsl:copy></xsl:template><xsl:template match=\"/node1/subnode2/text()\"><xsl:value-of select=\"$param1\"/></xsl:template></xsl:stylesheet>";
        XsltTransformer transformer = new XsltTransformer();
        transformer.setMuleContext(muleContext);
        transformer.setReturnDataType(DataType.STRING);
        transformer.setMuleContext(muleContext);
        transformer.setXslt(xsl);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("param1", "#[message.outboundProperties.myproperty]");
        transformer.setContextProperties(params);
        transformer.initialise();
        InternalMessage message = InternalMessage.builder().payload((Object)xml).addOutboundProperty("myproperty", (Serializable)((Object)param)).build();
        String transformerResult = (String)transformer.transform((Object)message);
        transformerResult = transformerResult.substring(transformerResult.indexOf("?>") + 2);
        Assert.assertTrue((transformerResult.indexOf(expectedTransformedxml) > -1 ? 1 : 0) != 0);
    }
}

