/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.xml.transformers.xml.xslt;

import java.io.File;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.mule.functional.junit4.FlowRunner;
import org.mule.functional.junit4.FunctionalTestCase;
import org.mule.runtime.core.util.FileUtils;
import org.mule.runtime.core.util.IOUtils;
import org.mule.runtime.core.util.UUID;

public class XsltResultDocumentTestCase
extends FunctionalTestCase {
    private static final String INPUT_FILE = "cities.xml";
    private static final String OUTPUT_FILE_PROPERTY = "outputFile";
    private static final String FLOW_NAME = "listCities";
    private static final String EXPECTED_OUTPUT = "italy - milan - 5 | france - paris - 7 | germany - munich - 4 | france - lyon - 2 | italy - venice - 1 | ";
    @Rule
    public TemporaryFolder temporaryFolder = new TemporaryFolder();

    protected String getConfigFile() {
        return "xsl/xslt-result-document-config.xml";
    }

    @Test
    public void writeToSameFileSeveralTimes() throws Exception {
        String cities = IOUtils.getResourceAsString((String)INPUT_FILE, ((Object)((Object)this)).getClass());
        File outputFile = this.temporaryFolder.newFile(UUID.getUUID());
        this.executeFlowAndValidateOutput(cities, outputFile);
        this.executeFlowAndValidateOutput(cities, outputFile);
    }

    private void executeFlowAndValidateOutput(String payload, File outputFile) throws Exception {
        outputFile.delete();
        this.withPayloadAndSessionProperty(this.flowRunner(FLOW_NAME), payload, OUTPUT_FILE_PROPERTY, outputFile.getAbsolutePath()).run();
        Assert.assertThat((Object)FileUtils.readFileToString((File)outputFile), (Matcher)CoreMatchers.is((Object)EXPECTED_OUTPUT));
    }

    private FlowRunner withPayloadAndSessionProperty(FlowRunner runner, Object payload, String propertyName, Object propertyValue) throws Exception {
        return (FlowRunner)((FlowRunner)runner.withPayload(payload)).withSessionProperty(propertyName, propertyValue);
    }
}

