/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.xml.transformers.xml.xquery;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.List;
import net.sf.saxon.dom.DocumentBuilderImpl;
import org.custommonkey.xmlunit.XMLUnit;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.mule.functional.junit4.FlowRunner;
import org.mule.functional.junit4.FunctionalTestCase;
import org.mule.runtime.core.util.IOUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XQuery3TestCase
extends FunctionalTestCase {
    private String input;

    protected String getConfigFile() {
        return "xquery/xquery3-config.xml";
    }

    protected void doSetUp() throws Exception {
        XMLUnit.setIgnoreWhitespace((boolean)true);
        this.input = IOUtils.getResourceAsString((String)"cd-catalog.xml", ((Object)((Object)this)).getClass());
    }

    @Test
    public void tryCatch() throws Exception {
        List elements = (List)((FlowRunner)this.flowRunner("tryCatch").withPayload((Object)this.input)).run().getMessage().getPayload().getValue();
        Assert.assertThat((Object)elements, (Matcher)Matchers.hasSize((int)1));
        Assert.assertThat((Object)((Element)elements.get(0)).getTagName(), (Matcher)CoreMatchers.equalTo((Object)"error"));
        Assert.assertThat((Object)((Element)elements.get(0)).getTextContent(), (Matcher)CoreMatchers.containsString((String)"Caught error"));
    }

    @Test
    public void switchStatement() throws Exception {
        List elements = (List)((FlowRunner)this.flowRunner("switch").withPayload((Object)this.input)).run().getMessage().getPayload().getValue();
        Assert.assertThat((Object)elements, (Matcher)Matchers.hasSize((int)1));
        Assert.assertThat((Object)((Element)elements.get(0)).getTagName(), (Matcher)CoreMatchers.equalTo((Object)"Quack"));
    }

    @Test
    public void groupBy() throws Exception {
        List elements = (List)((FlowRunner)this.flowRunner("groupBy").withPayload((Object)this.input)).run().getMessage().getPayload().getValue();
        Assert.assertThat((Object)elements, (Matcher)Matchers.hasSize((int)2));
        Assert.assertThat((Object)((Element)elements.get(0)).getTagName(), (Matcher)CoreMatchers.equalTo((Object)"odd"));
        Assert.assertThat((Object)((Element)elements.get(1)).getTagName(), (Matcher)CoreMatchers.equalTo((Object)"even"));
        Assert.assertThat((Object)((Element)elements.get(0)).getTextContent(), (Matcher)CoreMatchers.equalTo((Object)"1 3 5 7 9"));
        Assert.assertThat((Object)((Element)elements.get(1)).getTextContent(), (Matcher)CoreMatchers.equalTo((Object)"2 4 6 8 10"));
    }

    @Test
    public void books() throws Exception {
        List nodes = (List)((FlowRunner)this.flowRunner("books").withPayload((Object)this.getBooks())).run().getMessage().getPayload().getValue();
        Assert.assertThat((Object)nodes, (Matcher)Matchers.hasSize((int)6));
        Assert.assertThat((Object)((Node)nodes.get(0)).getLastChild().getTextContent(), (Matcher)CoreMatchers.equalTo((Object)"The Eyre Affair"));
    }

    @Test
    public void multipleInputsByPath() throws Exception {
        URL booksUrl = IOUtils.getResourceAsUrl((String)"books.xml", ((Object)((Object)this)).getClass());
        URL citiesURL = IOUtils.getResourceAsUrl((String)"cities.xml", ((Object)((Object)this)).getClass());
        this.assertMultipleInputs("multipleInputsByPath", booksUrl.getPath(), citiesURL.getPath());
    }

    @Test
    public void multipleInputsByParam() throws Exception {
        try (InputStream books = IOUtils.getResourceAsStream((String)"books.xml", ((Object)((Object)this)).getClass());
             InputStream cities = IOUtils.getResourceAsStream((String)"cities.xml", ((Object)((Object)this)).getClass());){
            DocumentBuilderImpl documentBuilder = new DocumentBuilderImpl();
            Document booksDocument = documentBuilder.parse(books);
            Document citiesDocument = documentBuilder.parse(cities);
            this.assertMultipleInputs("multipleInputsByParam", booksDocument, citiesDocument.getFirstChild());
        }
    }

    private void assertMultipleInputs(String flowName, Object books, Object cities) throws Exception {
        List elements = (List)((FlowRunner)((FlowRunner)((FlowRunner)this.flowRunner(flowName).withPayload((Object)this.input)).withVariable("books", books)).withVariable("cities", cities)).run().getMessage().getPayload().getValue();
        Assert.assertThat((Object)elements, (Matcher)Matchers.hasSize((int)1));
        NodeList childNodes = ((Element)elements.get(0)).getChildNodes();
        Assert.assertThat((Object)childNodes.getLength(), (Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(0)));
        NamedNodeMap firstChildAttributes = childNodes.item(0).getAttributes();
        Assert.assertThat((Object)firstChildAttributes.getNamedItem("title").getNodeValue(), (Matcher)CoreMatchers.equalTo((Object)"Pride and Prejudice"));
        Assert.assertThat((Object)firstChildAttributes.getNamedItem("city").getNodeValue(), (Matcher)CoreMatchers.equalTo((Object)"milan"));
    }

    private String getBooks() throws IOException {
        return IOUtils.getResourceAsString((String)"books.xml", ((Object)((Object)this)).getClass());
    }
}

