/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.xml.transformers.xml.xquery;

import java.util.HashMap;
import org.custommonkey.xmlunit.XMLUnit;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.core.api.message.InternalMessage;
import org.mule.runtime.core.api.transformer.Transformer;
import org.mule.runtime.core.transformer.AbstractTransformerTestCase;
import org.mule.runtime.core.util.IOUtils;
import org.mule.runtime.module.xml.transformer.XQueryTransformer;
import org.w3c.dom.Document;

public class InlineXQueryTransformerWithParamsTestCase
extends AbstractTransformerTestCase {
    private String srcData;
    private String resultData;

    protected void doSetUp() throws Exception {
        XMLUnit.setIgnoreWhitespace((boolean)true);
        XMLUnit.setIgnoreComments((boolean)true);
        this.srcData = IOUtils.getResourceAsString((String)"cd-catalog.xml", ((Object)((Object)this)).getClass());
        this.resultData = IOUtils.getResourceAsString((String)"cd-catalog-result-with-params.xml", ((Object)((Object)this)).getClass());
    }

    public Transformer getTransformer() throws Exception {
        XQueryTransformer transformer = new XQueryTransformer();
        transformer.setXquery("declare variable $document external;\ndeclare variable $title external;\ndeclare variable $rating external;\n <cd-listings title='{$title}' rating='{$rating}'>\n{\n    for $cd in $document/catalog/cd\n    return <cd-title>{data($cd/title)}</cd-title>\n} \n</cd-listings>");
        transformer.setReturnDataType(DataType.STRING);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("title", "#[message.outboundProperties.ListTitle]");
        params.put("rating", "#[message.outboundProperties.ListRating]");
        transformer.setContextProperties(params);
        transformer.setMuleContext(muleContext);
        transformer.initialise();
        return transformer;
    }

    public Transformer getRoundTripTransformer() throws Exception {
        return null;
    }

    public void testRoundtripTransform() throws Exception {
    }

    public Object getTestData() {
        HashMap<String, Object> props = new HashMap<String, Object>(2);
        props.put("ListTitle", "MyList");
        props.put("ListRating", new Integer(6));
        return InternalMessage.builder().payload((Object)this.srcData).outboundProperties(props).build();
    }

    public Object getResultData() {
        return this.resultData;
    }

    public boolean compareResults(Object expected, Object result) {
        if (expected instanceof Document && result instanceof Document) {
            return XMLUnit.compareXML((Document)((Document)expected), (Document)((Document)result)).similar();
        }
        if (expected instanceof String && result instanceof String) {
            try {
                String expectedString = this.normalizeString((String)expected);
                String resultString = this.normalizeString((String)result);
                return XMLUnit.compareXML((String)expectedString, (String)resultString).similar();
            }
            catch (Exception ex) {
                return false;
            }
        }
        return super.compareResults(expected, result);
    }
}

