/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.xml.transformers.xml;

import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.junit.Test;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.core.api.transformer.Transformer;
import org.mule.runtime.core.message.OutputHandler;
import org.mule.runtime.module.xml.transformer.XmlToDomDocument;
import org.mule.runtime.module.xml.transformer.XmlToXMLStreamReader;
import org.mule.runtime.module.xml.transformers.xml.AbstractXmlTransformerTestCase;
import org.mule.runtime.module.xml.util.XMLUtils;

public class XmlToXMLStreamReaderTestCase
extends AbstractXmlTransformerTestCase {
    private static final String TEST_XML = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><test>TEST_MESSAGE</test>";

    public Transformer getTransformer() throws Exception {
        return (Transformer)this.createObject(XmlToXMLStreamReader.class);
    }

    public Transformer getRoundTripTransformer() throws Exception {
        Transformer t = (Transformer)this.createObject(XmlToDomDocument.class);
        t.setReturnDataType(DataType.STRING);
        return t;
    }

    public Object getTestData() {
        return TEST_XML;
    }

    public Object getResultData() {
        try {
            return XMLUtils.toXMLStreamReader((XMLInputFactory)XMLInputFactory.newFactory(), (Object)TEST_XML);
        }
        catch (XMLStreamException e) {
            throw new RuntimeException(e);
        }
    }

    @Test
    public void supportsOutputHandlerAsSourceType() throws Exception {
        OutputHandler outputHandler = (event, out) -> out.write(TEST_XML.getBytes());
        XMLStreamReader result = (XMLStreamReader)this.getTransformer().transform((Object)outputHandler);
        this.compareResults(this.getResultData(), result);
    }
}

