/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.xml.transformers.xml;

import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.Set;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.core.IsInstanceOf;
import org.junit.Assert;
import org.junit.Test;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.core.api.message.InternalMessage;
import org.mule.runtime.module.xml.transformer.ObjectToXml;
import org.mule.runtime.module.xml.transformer.XmlToObject;
import org.mule.tck.junit4.AbstractMuleContextTestCase;
import org.mule.tck.testmodels.fruit.Apple;

public class XmlMuleMessageTransformersTestCase
extends AbstractMuleContextTestCase {
    @Test
    public void testMessageSerialization() throws Exception {
        ObjectToXml t1 = (ObjectToXml)this.createObject(ObjectToXml.class);
        t1.setAcceptMuleMessage(true);
        InternalMessage msg = InternalMessage.builder().payload((Object)"test").mediaType(MediaType.ANY.withCharset(StandardCharsets.UTF_8)).addOutboundProperty("object", (Serializable)new Apple()).addOutboundProperty("string", (Serializable)((Object)"hello")).build();
        String xml = (String)t1.transform((Object)msg);
        Assert.assertNotNull((Object)xml);
        XmlToObject t2 = (XmlToObject)this.createObject(XmlToObject.class);
        Object result = t2.transform((Object)xml);
        Assert.assertNotNull((Object)result);
        Assert.assertThat((Object)result, (Matcher)IsInstanceOf.instanceOf(InternalMessage.class));
        msg = (InternalMessage)result;
        Assert.assertEquals((Object)"test", (Object)this.getPayloadAsString(msg));
        Assert.assertEquals((Object)new Apple(), (Object)msg.getOutboundProperty("object"));
        Assert.assertEquals((Object)new Apple(), (Object)msg.getOutboundProperty("oBjeCt"));
        Assert.assertNull((Object)msg.getInboundProperty("oBjeCt"));
        Assert.assertEquals((Object)"hello", (Object)msg.getOutboundProperty("string"));
        Assert.assertEquals((Object)"hello", (Object)msg.getOutboundProperty("String"));
        Assert.assertNull((Object)msg.getInboundProperty("string"));
        Assert.assertNull((Object)msg.getInboundProperty("number"));
        Assert.assertNull((Object)msg.getOutboundProperty("number"));
        Assert.assertThat(msg.getPayload().getDataType().getMediaType().getCharset().get(), (Matcher)CoreMatchers.is((Object)StandardCharsets.UTF_8));
        Set outboundProps = msg.getOutboundPropertyNames();
        Assert.assertThat((Object)outboundProps, (Matcher)Matchers.hasSize((int)2));
        for (String key : outboundProps) {
            Assert.assertTrue((key.equals("number") || key.equals("string") || key.equals("object") ? 1 : 0) != 0);
            Assert.assertFalse((key.equals("NUMBER") || key.equals("STRING") || key.equals("OBJECT") ? 1 : 0) != 0);
        }
    }
}

