/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.xml.transformers.xml;

import java.io.InputStream;
import java.util.Collection;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.custommonkey.xmlunit.XMLAssert;
import org.junit.Test;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.core.api.transformer.Transformer;
import org.mule.runtime.core.api.transformer.TransformerException;
import org.mule.runtime.core.util.IOUtils;
import org.mule.runtime.module.xml.transformer.XsltTransformer;
import org.mule.tck.junit4.AbstractMuleContextTestCase;

public class ParallelXsltTransformerTestCase
extends AbstractMuleContextTestCase {
    private String srcData;
    private String resultData;
    private Collection<Object> actualResults = new ConcurrentLinkedQueue<Object>();
    int running = 0;

    protected void doSetUp() throws Exception {
        this.srcData = IOUtils.toString((InputStream)IOUtils.getResourceAsStream((String)"cdcatalog-utf-8.xml", ((Object)((Object)this)).getClass()), (String)"UTF-8");
        this.resultData = IOUtils.toString((InputStream)IOUtils.getResourceAsStream((String)"cdcatalog-utf-8.html", ((Object)((Object)this)).getClass()), (String)"UTF-8");
    }

    public Transformer getTransformer() throws Exception {
        XsltTransformer transformer = new XsltTransformer();
        transformer.setReturnDataType(DataType.STRING);
        transformer.setXslFile("cdcatalog.xsl");
        transformer.setMuleContext(muleContext);
        transformer.initialise();
        return transformer;
    }

    public synchronized void signalStarted() {
        ++this.running;
    }

    public synchronized void signalDone() {
        if (--this.running == 0) {
            ((Object)((Object)this)).notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testParallelTransformation() throws Exception {
        Transformer transformer = this.getTransformer();
        long startTime = System.currentTimeMillis();
        for (int i = 0; i < this.getParallelThreadCount(); ++i) {
            new Thread(() -> {
                this.signalStarted();
                for (int j = 0; j < this.getCallsPerThread(); ++j) {
                    try {
                        this.actualResults.add(transformer.transform((Object)this.srcData));
                        continue;
                    }
                    catch (TransformerException e) {
                        this.actualResults.add((Object)e);
                    }
                }
                this.signalDone();
            }).start();
        }
        ParallelXsltTransformerTestCase i = this;
        synchronized (i) {
            ((Object)((Object)this)).wait();
        }
        long endTime = System.currentTimeMillis();
        this.checkResult();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Parallel transformations in " + this.getParallelThreadCount() + " threads with " + this.getCallsPerThread() + " calls/thread took " + (endTime - startTime) + " ms.");
        }
    }

    protected void checkResult() throws Exception {
        String expectedResult = this.resultData;
        for (Object result : this.actualResults) {
            if (result instanceof Exception) {
                throw (Exception)result;
            }
            if (expectedResult instanceof String && result instanceof String) {
                XMLAssert.assertXMLEqual((String)expectedResult, (String)((String)result));
                continue;
            }
            XMLAssert.assertEquals((Object)expectedResult, (Object)result);
        }
    }

    private int getParallelThreadCount() {
        return 20;
    }

    private int getCallsPerThread() {
        return 100;
    }
}

