/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.xml.transformer;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.security.AnyTypePermission;
import java.beans.EventHandler;
import java.io.InputStream;
import java.nio.channels.Channel;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import javax.activation.DataSource;
import javax.sql.rowset.BaseRowSet;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.transformer.TransformerException;
import org.mule.config.i18n.MessageFactory;
import org.mule.module.xml.transformer.XStreamFactory;
import org.mule.transformer.AbstractMessageTransformer;

public abstract class AbstractXStreamTransformer
extends AbstractMessageTransformer {
    private final AtomicReference<XStream> xstream = new AtomicReference();
    private volatile String driverClass = "com.thoughtworks.xstream.io.xml.XppDriver";
    private volatile Map<String, Class<?>> aliases = new HashMap();
    private volatile Set<Class<? extends Converter>> converters = new HashSet<Class<? extends Converter>>();
    protected boolean isDenylistEnabled = Boolean.getBoolean("mule.enable.xstream.denylist");
    private String allowlist = System.getProperty("mule.xstream.allowlist");

    public void initialise() throws InitialisationException {
        super.initialise();
        try {
            XStream xStreamInstance = this.getXStream();
            xStreamInstance.setClassLoader(Thread.currentThread().getContextClassLoader());
        }
        catch (TransformerException e) {
            throw new InitialisationException((Throwable)e, (Initialisable)this);
        }
    }

    public final XStream getXStream() throws TransformerException {
        XStream instance = this.xstream.get();
        if (instance == null) {
            try {
                instance = new XStreamFactory(this.driverClass, this.aliases, this.converters).getInstance();
                if (!this.xstream.compareAndSet(null, instance)) {
                    instance = this.xstream.get();
                }
                if (this.isDenylistEnabled) {
                    instance.addPermission(AnyTypePermission.ANY);
                    instance.denyTypes(new String[]{"javax.imageio.ImageIO$ContainsFilter", "sun.awt.datatransfer.DataTransferer$IndexOrderComparator", "com.sun.tools.javac.processing.JavacProcessingEnvironment$NameProcessIterator"});
                    instance.denyTypes(new Class[]{ProcessBuilder.class, EventHandler.class, ProcessBuilder.class, Void.class, Void.TYPE});
                    instance.denyTypesByRegExp(new String[]{".*\\$ServiceNameIterator", "javafx\\.collections\\.ObservableList\\$.*", ".*\\.bcel\\..*\\.util\\.ClassLoader", ".*\\$GetterSetterReflection", ".*\\$LazyIterator", ".*\\$PrivilegedGetter", ".*\\.ws\\.client\\.sei\\..*", ".*\\$ProxyLazyValue", "com\\.sun\\.jndi\\..*Enumerat(?:ion|tor)", ".*\\$URLData", ".*\\.xsltc\\.trax\\.TemplatesImpl"});
                    instance.denyTypesByWildcard(new String[]{"sun.reflect.**", "sun.tracing.**", "com.sun.corba.**"});
                    instance.denyTypeHierarchy(InputStream.class);
                    instance.denyTypeHierarchy(Channel.class);
                    instance.denyTypeHierarchy(DataSource.class);
                    instance.denyTypeHierarchy(BaseRowSet.class);
                } else if (this.allowlist != null) {
                    String[] allowlistItems;
                    for (String item : allowlistItems = this.allowlist.split(",")) {
                        if (item.endsWith("*")) {
                            instance.allowTypesByWildcard(new String[]{item});
                            continue;
                        }
                        instance.allowTypes(new String[]{item});
                    }
                }
            }
            catch (Exception e) {
                throw new TransformerException(MessageFactory.createStaticMessage((String)"Unable to initialize XStream"), (Throwable)e);
            }
        }
        return instance;
    }

    public Object clone() throws CloneNotSupportedException {
        AbstractXStreamTransformer clone = (AbstractXStreamTransformer)((Object)super.clone());
        clone.setDriverClass(this.driverClass);
        if (this.aliases != null) {
            clone.setAliases(new HashMap(this.aliases));
        }
        if (this.converters != null) {
            clone.setConverters(new HashSet<Class<? extends Converter>>(this.converters));
        }
        return clone;
    }

    public String getDriverClass() {
        return this.driverClass;
    }

    public void setDriverClass(String driverClass) {
        this.driverClass = driverClass;
        this.xstream.set(null);
    }

    public Map<String, Class<?>> getAliases() {
        return this.aliases;
    }

    public void setAliases(Map<String, Class<?>> aliases) {
        this.aliases = aliases;
        this.xstream.set(null);
    }

    public Set<Class<? extends Converter>> getConverters() {
        return this.converters;
    }

    public void setConverters(Set<Class<? extends Converter>> converters) {
        this.converters = converters;
        this.xstream.set(null);
    }

    public void addAlias(String alias, Class<?> aClass) {
        this.aliases.put(alias, aClass);
    }

    public Class<?> removeAlias(String alias) {
        return this.aliases.remove(alias);
    }

    public void addConverter(Class<? extends Converter> converterClass) {
        this.converters.add(converterClass);
    }

    public boolean removeAlias(Class<? extends Converter> converterClass) {
        return this.converters.remove(converterClass);
    }
}

