/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.xml.filters;

import java.io.InputStream;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Answers;
import org.mockito.Mock;
import org.mockito.runners.MockitoJUnitRunner;
import org.mule.DefaultMuleMessage;
import org.mule.api.MuleContext;
import org.mule.api.MuleMessage;
import org.mule.module.xml.filters.SchemaValidationFilter;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.junit4.rule.SystemProperty;
import org.mule.tck.size.SmallTest;
import org.mule.transformer.types.DataTypeFactory;
import org.mule.util.IOUtils;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXParseException;

@RunWith(value=MockitoJUnitRunner.class)
@SmallTest
public class SchemaValidationTestCase
extends AbstractMuleTestCase {
    @Rule
    public SystemProperty externalEntities = new SystemProperty("mule.xml.expandExternalEntities", "true");
    private static final String SIMPLE_SCHEMA = "schema/schema1.xsd";
    private static final String INCLUDE_SCHEMA = "schema/schema-with-include.xsd";
    private static final String VALID_XML_FILE = "/validation1.xml";
    private static final String INVALID_XML_FILE = "/validation2.xml";
    private final TestErrorHandler errorHandler = new TestErrorHandler();
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    private MuleContext muleContext;

    @Test
    public void testValidate() throws Exception {
        SchemaValidationFilter filter = new SchemaValidationFilter();
        filter.setSchemaLocations(SIMPLE_SCHEMA);
        filter.initialise();
        Assert.assertThat((Object)filter.accept((MuleMessage)new DefaultMuleMessage((Object)((Object)((Object)this)).getClass().getResourceAsStream(VALID_XML_FILE), this.muleContext)), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)filter.accept((MuleMessage)new DefaultMuleMessage((Object)((Object)((Object)this)).getClass().getResourceAsStream(INVALID_XML_FILE), this.muleContext)), (Matcher)CoreMatchers.is((Object)false));
    }

    @Test
    public void testDefaultResourceResolverIsPresent() throws Exception {
        SchemaValidationFilter filter = new SchemaValidationFilter();
        filter.setSchemaLocations(SIMPLE_SCHEMA);
        filter.initialise();
        Assert.assertThat((Object)filter.getResourceResolver(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue())));
    }

    @Test
    public void testValidateWithIncludes() throws Exception {
        SchemaValidationFilter filter = new SchemaValidationFilter();
        filter.setSchemaLocations(INCLUDE_SCHEMA);
        filter.initialise();
        DefaultMuleMessage message = new DefaultMuleMessage((Object)((Object)((Object)this)).getClass().getResourceAsStream(VALID_XML_FILE), this.muleContext);
        Assert.assertThat((Object)filter.accept((MuleMessage)message), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)filter.accept((MuleMessage)new DefaultMuleMessage((Object)((Object)((Object)this)).getClass().getResourceAsStream(INVALID_XML_FILE), this.muleContext)), (Matcher)CoreMatchers.is((Object)false));
    }

    @Test
    public void testValidationDataTypeNotModified() throws Exception {
        SchemaValidationFilter filter = new SchemaValidationFilter();
        filter.setSchemaLocations(SIMPLE_SCHEMA);
        filter.initialise();
        DefaultMuleMessage message = new DefaultMuleMessage(null, this.muleContext);
        message.setPayload((Object)IOUtils.toString((InputStream)((Object)((Object)this)).getClass().getResourceAsStream(VALID_XML_FILE)), DataTypeFactory.XML_STRING);
        Assert.assertThat((Object)filter.accept((MuleMessage)message), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)message.getDataType().getMimeType(), (Matcher)CoreMatchers.is((Object)"text/xml"));
        Assert.assertThat((Object)filter.accept((MuleMessage)new DefaultMuleMessage((Object)((Object)((Object)this)).getClass().getResourceAsStream(INVALID_XML_FILE), this.muleContext)), (Matcher)CoreMatchers.is((Object)false));
    }

    @Test
    public void testErrorHandler() throws Exception {
        SchemaValidationFilter filter = new SchemaValidationFilter();
        filter.setSchemaLocations(SIMPLE_SCHEMA);
        filter.initialise();
        filter.setErrorHandler((ErrorHandler)this.errorHandler);
        Assert.assertThat((Object)filter.accept((MuleMessage)new DefaultMuleMessage((Object)((Object)((Object)this)).getClass().getResourceAsStream(INVALID_XML_FILE), this.muleContext)), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)this.errorHandler.exception, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
    }

    private class TestErrorHandler
    implements ErrorHandler {
        private Exception exception = null;

        private TestErrorHandler() {
        }

        @Override
        public void warning(SAXParseException exception) throws SAXParseException {
            this.exception = exception;
            throw exception;
        }

        @Override
        public void error(SAXParseException exception) throws SAXParseException {
            this.exception = exception;
            throw exception;
        }

        @Override
        public void fatalError(SAXParseException exception) throws SAXParseException {
            this.exception = exception;
            throw exception;
        }
    }
}

