/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transformers.xml.xslt;

import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mule.api.transformer.TransformerMessagingException;
import org.mule.tck.junit4.FunctionalTestCase;

public class XsltTransformerBLTestCase
extends FunctionalTestCase {
    @Rule
    public ExpectedException exception = ExpectedException.none();

    protected String getConfigFile() {
        return "xslt-bl-config.xml";
    }

    protected String makeInput() {
        return "<?xml version=\"1.0\" encoding=\"UTF-8\"?><!DOCTYPE foo [<!ENTITY lol1 \"01\"><!ENTITY lol2 \"&lol1;&lol1;\"><!ENTITY lol3 \"&lol2;&lol2;\"><!ENTITY lol4 \"&lol3;&lol3;\">]> \n<entityName>Hello123456890 &lol4;&lol4;&lol4;</entityName>";
    }

    @Test
    public void enabled() throws Exception {
        String input = this.makeInput();
        byte[] payload = input.getBytes();
        String output = (String)this.runFlow("flowBLEnabled", payload).getMessage().getPayload();
        Assert.assertThat((Object)output, (Matcher)Matchers.containsString((String)"010101010101010101010101010101010101010101010101"));
    }

    @Test
    public void disabled() throws Exception {
        String input = this.makeInput();
        byte[] payload = input.getBytes();
        this.exception.expect(TransformerMessagingException.class);
        this.exception.expectMessage("Undeclared general entity");
        String output = (String)this.runFlow("flowBLDisabled", payload).getMessage().getPayload();
    }
}

