/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transformers.xml.xquery;

import java.io.InputStream;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.custommonkey.xmlunit.XMLAssert;
import org.custommonkey.xmlunit.XMLUnit;
import org.junit.Assert;
import org.junit.Test;
import org.mule.MessageExchangePattern;
import org.mule.RequestContext;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.construct.FlowConstruct;
import org.mule.api.transformer.Transformer;
import org.mule.api.transformer.TransformerException;
import org.mule.construct.Flow;
import org.mule.module.xml.transformer.XQueryTransformer;
import org.mule.tck.MuleTestUtils;
import org.mule.tck.junit4.AbstractMuleContextTestCase;
import org.mule.transformer.types.DataTypeFactory;
import org.mule.util.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParallelXQueryTransformerTestCase
extends AbstractMuleContextTestCase {
    private static final Logger LOGGER = LoggerFactory.getLogger(ParallelXQueryTransformerTestCase.class);
    private static final int TIMEOUT_MILLIS = 30000;
    private String srcData;
    private String resultData;
    private ConcurrentLinkedQueue<Object> actualResults = new ConcurrentLinkedQueue();
    private CountDownLatch latch = new CountDownLatch(this.getParallelThreadCount());

    protected void doSetUp() throws Exception {
        this.srcData = IOUtils.toString((InputStream)IOUtils.getResourceAsStream((String)"cd-catalog.xml", ((Object)((Object)this)).getClass()));
        this.resultData = IOUtils.toString((InputStream)IOUtils.getResourceAsStream((String)"cd-catalog-result.xml", ((Object)((Object)this)).getClass()));
        XMLUnit.setIgnoreWhitespace((boolean)true);
        XMLUnit.setIgnoreComments((boolean)true);
    }

    public Transformer getTransformer() throws Exception {
        XQueryTransformer transformer = new XQueryTransformer();
        transformer.setReturnDataType(DataTypeFactory.STRING);
        transformer.setXqueryFile("cd-catalog.xquery");
        transformer.setMuleContext(muleContext);
        transformer.initialise();
        return transformer;
    }

    public synchronized void signalDone() {
        this.latch.countDown();
    }

    @Test
    public void testParallelTransformation() throws Exception {
        final Transformer transformer = this.getTransformer();
        final Flow testFlow = MuleTestUtils.getTestFlow((MuleContext)muleContext);
        long startTime = System.currentTimeMillis();
        for (int i = 0; i < this.getParallelThreadCount(); ++i) {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        RequestContext.setEvent((MuleEvent)MuleTestUtils.getTestEvent((Object)"test", (FlowConstruct)testFlow, (MessageExchangePattern)MessageExchangePattern.REQUEST_RESPONSE, (MuleContext)muleContext));
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        return;
                    }
                    for (int j = 0; j < ParallelXQueryTransformerTestCase.this.getCallsPerThread(); ++j) {
                        try {
                            ParallelXQueryTransformerTestCase.this.actualResults.add(transformer.transform((Object)ParallelXQueryTransformerTestCase.this.srcData));
                            continue;
                        }
                        catch (TransformerException e) {
                            ParallelXQueryTransformerTestCase.this.actualResults.add(e);
                        }
                    }
                    ParallelXQueryTransformerTestCase.this.signalDone();
                }
            }).start();
        }
        Assert.assertTrue((boolean)this.latch.await(30000L, TimeUnit.MILLISECONDS));
        long endTime = System.currentTimeMillis();
        this.checkResult();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Parallel transformations in " + this.getParallelThreadCount() + " threads with " + this.getCallsPerThread() + " calls/thread took " + (endTime - startTime) + " ms.");
        }
    }

    protected void checkResult() throws Exception {
        String expectedResult = this.resultData;
        for (Object result : this.actualResults) {
            if (result instanceof Exception) {
                throw (Exception)result;
            }
            if (expectedResult != null && result instanceof String) {
                XMLAssert.assertXMLEqual((String)expectedResult, (String)((String)result));
                continue;
            }
            XMLAssert.assertEquals((Object)expectedResult, (Object)result);
        }
    }

    private int getParallelThreadCount() {
        return Runtime.getRuntime().availableProcessors();
    }

    private int getCallsPerThread() {
        return 100;
    }
}

