/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transformers.xml;

import java.io.ByteArrayInputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.mule.api.registry.RegistrationException;
import org.mule.api.transformer.TransformerException;
import org.mule.module.xml.transformer.XPathExtractor;
import org.mule.module.xml.util.NamespaceManager;
import org.mule.module.xml.xpath.XPathReturnType;
import org.mule.tck.junit4.AbstractMuleContextTestCase;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class XPathExtractorTestCase
extends AbstractMuleContextTestCase {
    protected static final String TEST_XML_MULTI_RESULTS = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><root><node>value1</node><node>value2</node><node>value3</node></root>";
    protected static final String TEST_XML_MULTI_NESTED_RESULTS = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><root><node><subnode1>val1</subnode1><subnode2>val2</subnode2></node><node><subnode1>val3</subnode1><subnode2>val4</subnode2></node></root>";
    protected static final String TEST_XML_SINGLE_RESULT = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><root><node>value1</node><node2>2</node2></root>";
    protected static final String TEST_XML_WITH_NAMESPACES = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><root xmlns:f=\"http://www.w3schools.com/furniture\"><f:table><f:name>African Coffee Table</f:name><f:width>80</f:width><f:length>120</f:length></f:table></root>";

    @Test(expected=RegistrationException.class)
    public void expressionIsRequired() throws Exception {
        this.createObject(XPathExtractor.class);
    }

    @Test(expected=TransformerException.class)
    public void badExpression() throws Exception {
        String badExpression = "/$@\u00ef\u00bf\u00bd%$\u00ef\u00bf\u00bd&\u00ef\u00bf\u00bd$$\u00ef\u00bf\u00bd%";
        XPathExtractor extractor = this.initialiseExtractor("/$@\u00ef\u00bf\u00bd%$\u00ef\u00bf\u00bd&\u00ef\u00bf\u00bd$$\u00ef\u00bf\u00bd%", XPathReturnType.STRING);
        Document doc = this.getDocumentForString(TEST_XML_SINGLE_RESULT);
        extractor.transform((Object)doc);
    }

    @Test
    public void nodeToStringResult() throws Exception {
        String expression = "/root/node";
        XPathExtractor extractor = this.initialiseExtractor("/root/node", XPathReturnType.STRING);
        Assert.assertEquals((String)"Wrong expression returned.", (Object)"/root/node", (Object)extractor.getExpression());
        Document doc = this.getDocumentForString(TEST_XML_SINGLE_RESULT);
        Object objResult = extractor.transform((Object)doc);
        Assert.assertNotNull((Object)objResult);
        String result = (String)objResult;
        Assert.assertEquals((String)"Wrong value extracted.", (Object)"value1", (Object)result);
    }

    @Test
    public void inputSourceToStringResult() throws Exception {
        String expression = "/root/node";
        XPathExtractor extractor = this.initialiseExtractor("/root/node", XPathReturnType.STRING);
        Document doc = this.getDocumentForString(TEST_XML_SINGLE_RESULT);
        InputSource source = this.getInputSourceForDocument(doc);
        Object objResult = extractor.transform((Object)source);
        Assert.assertNotNull((Object)objResult);
        String result = (String)objResult;
        Assert.assertEquals((String)"Wrong value extracted.", (Object)"value1", (Object)result);
    }

    @Test
    public void nodeToNumberResult() throws Exception {
        String expression = "/root/node2";
        XPathExtractor extractor = this.initialiseExtractor("/root/node2", XPathReturnType.NUMBER);
        Document doc = this.getDocumentForString(TEST_XML_SINGLE_RESULT);
        Object objResult = extractor.transform((Object)doc);
        Assert.assertNotNull((Object)objResult);
        double result = (Double)objResult;
        Assert.assertEquals((String)"Wrong value extracted.", (double)2.0, (double)result, (double)0.0);
    }

    @Test
    public void nodeToBooleanResult() throws Exception {
        String expression = "/root/node2";
        XPathExtractor extractor = this.initialiseExtractor("/root/node2", XPathReturnType.BOOLEAN);
        Document doc = this.getDocumentForString(TEST_XML_SINGLE_RESULT);
        Object objResult = extractor.transform((Object)doc);
        Assert.assertNotNull((Object)objResult);
        Boolean result = (Boolean)objResult;
        Assert.assertEquals((String)"Wrong value extracted.", (Object)Boolean.TRUE, (Object)result);
    }

    @Test
    public void nodeToNodeResult() throws Exception {
        String expression = "/root/node2";
        XPathExtractor extractor = this.initialiseExtractor("/root/node2", XPathReturnType.NODE);
        Document doc = this.getDocumentForString(TEST_XML_SINGLE_RESULT);
        Object objResult = extractor.transform((Object)doc);
        Assert.assertNotNull((Object)objResult);
        Node result = (Node)objResult;
        Assert.assertEquals((String)"Wrong value extracted.", (Object)"node2", (Object)result.getNodeName());
    }

    @Test
    public void nodeToNodeSetResult() throws Exception {
        String expression = "/root/node2";
        XPathExtractor extractor = this.initialiseExtractor("/root/node2", XPathReturnType.NODESET);
        Document doc = this.getDocumentForString(TEST_XML_SINGLE_RESULT);
        Object objResult = extractor.transform((Object)doc);
        Assert.assertThat((Object)objResult, (Matcher)CoreMatchers.instanceOf(NodeList.class));
        NodeList result = (NodeList)objResult;
        Assert.assertEquals((String)"Wrong value extracted.", (Object)"node2", (Object)result.item(0).getNodeName());
    }

    @Test
    public void nodeToStringResultWithNameSpaces() throws Exception {
        this.registerNamespaces();
        String expression = "//f:width";
        XPathExtractor extractor = this.initialiseExtractor("//f:width", XPathReturnType.STRING);
        Assert.assertEquals((String)"Wrong expression returned.", (Object)"//f:width", (Object)extractor.getExpression());
        Document doc = this.getDocumentForString(TEST_XML_WITH_NAMESPACES);
        Object objResult = extractor.transform((Object)doc);
        Assert.assertNotNull((Object)objResult);
        String result = (String)objResult;
        Assert.assertEquals((String)"Wrong value extracted.", (Object)"80", (Object)result);
    }

    @Test
    public void xpathNamespacesInitialization() throws Exception {
        this.registerNamespaces();
        String expression = "//f:width";
        XPathExtractor extractor = this.initialiseExtractor("//f:width", XPathReturnType.STRING);
        Map namespaces = extractor.getXpathEvaluator().getRegisteredNamespaces();
        Assert.assertEquals((Object)"http://www.w3schools.com/furniture", namespaces.get("f"));
    }

    @Test
    public void namespacesNonOverwritten() throws Exception {
        this.registerNamespaces();
        HashMap<String, String> namespaces = new HashMap<String, String>();
        namespaces.put("g", "http://www.test.com/g");
        String expression = "//f:width";
        XPathExtractor extractor = this.initialiseExtractor("//f:width", XPathReturnType.STRING);
        extractor.setNamespaces(namespaces);
        Assert.assertEquals((Object)"http://www.test.com/g", extractor.getNamespaces().get("g"));
    }

    private void registerNamespaces() throws RegistrationException {
        NamespaceManager namespaceManager = new NamespaceManager();
        HashMap<String, String> namespaces = new HashMap<String, String>();
        namespaces.put("f", "http://www.w3schools.com/furniture");
        namespaceManager.setNamespaces(namespaces);
        muleContext.getRegistry().unregisterObject("_muleNamespaceManager");
        muleContext.getRegistry().registerObject("_muleNamespaceManager", (Object)namespaceManager);
    }

    private XPathExtractor initialiseExtractor(String expression, XPathReturnType resultType) throws RegistrationException {
        XPathExtractor extractor = new XPathExtractor();
        extractor.setExpression(expression);
        extractor.setResultType(resultType);
        this.initialiseObject(extractor);
        return extractor;
    }

    private Document getDocumentForString(String xml) throws Exception {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document doc = builder.parse(new ByteArrayInputStream(xml.getBytes()));
        return doc;
    }

    private InputSource getInputSourceForDocument(Document doc) throws Exception {
        DOMSource source = new DOMSource(doc);
        StringWriter xmlWriter = new StringWriter();
        StreamResult xmlResult = new StreamResult(xmlWriter);
        TransformerFactory.newInstance().newTransformer().transform(source, xmlResult);
        StringReader xmlReader = new StringReader(xmlWriter.toString());
        return new InputSource(xmlReader);
    }
}

