/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transformers.jaxb;

import java.io.ByteArrayInputStream;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.mule.DefaultMuleMessage;
import org.mule.api.transformer.DataType;
import org.mule.jaxb.model.EmailAddress;
import org.mule.jaxb.model.Person;
import org.mule.tck.junit4.AbstractMuleContextTestCase;
import org.mule.transformer.types.DataTypeFactory;
import org.mule.transformer.types.ListDataType;
import org.mule.transformers.jaxb.JAXBTestTransformers;

public class JaxbTransformerTestCase
extends AbstractMuleContextTestCase {
    public static final String PERSON_XML = "<person><name>John Doe</name><dob>01/01/1970</dob><emailAddresses><emailAddress><type>home</type><address>john.doe@gmail.com</address></emailAddress><emailAddress><type>work</type><address>jdoe@bigco.com</address></emailAddress></emailAddresses></person>";

    public void doSetUp() throws Exception {
        muleContext.getRegistry().registerObject("trans", (Object)new JAXBTestTransformers());
    }

    @Test
    public void testCustomTransform() throws Exception {
        DefaultMuleMessage message = new DefaultMuleMessage((Object)PERSON_XML, muleContext);
        Person person = (Person)message.getPayload(DataTypeFactory.create(Person.class));
        Assert.assertNotNull((Object)person);
        Assert.assertEquals((Object)"John Doe", (Object)person.getName());
        Assert.assertEquals((Object)"01/01/1970", (Object)person.getDob());
        Assert.assertEquals((long)2L, (long)person.getEmailAddresses().size());
        Assert.assertEquals((Object)"home", (Object)person.getEmailAddresses().get(0).getType());
        Assert.assertEquals((Object)"john.doe@gmail.com", (Object)person.getEmailAddresses().get(0).getAddress());
        Assert.assertEquals((Object)"work", (Object)person.getEmailAddresses().get(1).getType());
        Assert.assertEquals((Object)"jdoe@bigco.com", (Object)person.getEmailAddresses().get(1).getAddress());
    }

    @Test
    public void testCustomTransformWithMuleMessage() throws Exception {
        ByteArrayInputStream in = new ByteArrayInputStream(PERSON_XML.getBytes());
        DefaultMuleMessage msg = new DefaultMuleMessage((Object)in, muleContext);
        msg.setInboundProperty("foo", (Object)"fooValue");
        List emailAddresses = (List)msg.getPayload((DataType)new ListDataType(EmailAddress.class));
        Assert.assertNotNull((Object)emailAddresses);
        Assert.assertEquals((long)2L, (long)emailAddresses.size());
        Assert.assertEquals((Object)"home", (Object)((EmailAddress)emailAddresses.get(0)).getType());
        Assert.assertEquals((Object)"john.doe@gmail.com", (Object)((EmailAddress)emailAddresses.get(0)).getAddress());
        Assert.assertEquals((Object)"work", (Object)((EmailAddress)emailAddresses.get(1)).getType());
        Assert.assertEquals((Object)"jdoe@bigco.com", (Object)((EmailAddress)emailAddresses.get(1)).getAddress());
    }
}

