/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transformers.jaxb;

import java.util.Arrays;
import javax.xml.bind.JAXBContext;
import org.custommonkey.xmlunit.XMLUnit;
import org.junit.Assert;
import org.mule.api.transformer.Transformer;
import org.mule.jaxb.model.EmailAddress;
import org.mule.jaxb.model.Person;
import org.mule.module.xml.transformer.jaxb.JAXBMarshallerTransformer;
import org.mule.module.xml.transformer.jaxb.JAXBUnmarshallerTransformer;
import org.mule.transformer.AbstractTransformerTestCase;
import org.mule.transformer.types.DataTypeFactory;

public class JaxbRoundtripTestCase
extends AbstractTransformerTestCase {
    protected JAXBContext ctx;

    protected void doSetUp() throws Exception {
        this.ctx = JAXBContext.newInstance((Class[])new Class[]{Person.class});
        super.doSetUp();
    }

    public Transformer getTransformer() throws Exception {
        JAXBUnmarshallerTransformer t = new JAXBUnmarshallerTransformer(this.ctx, DataTypeFactory.create(Person.class));
        this.initialiseObject(t);
        return t;
    }

    public Transformer getRoundTripTransformer() throws Exception {
        JAXBMarshallerTransformer t = new JAXBMarshallerTransformer(this.ctx, DataTypeFactory.STRING);
        this.initialiseObject(t);
        return t;
    }

    public Object getTestData() {
        return "<person><name>John Doe</name><dob>01/01/1970</dob><emailAddresses><emailAddress><type>home</type><address>john.doe@gmail.com</address></emailAddress><emailAddress><type>work</type><address>jdoe@bigco.com</address></emailAddress></emailAddresses></person>";
    }

    public Object getResultData() {
        Person p = new Person();
        p.setName("John Doe");
        p.setDob("01/01/1970");
        EmailAddress ea = new EmailAddress("john.doe@gmail.com", "home");
        EmailAddress ea2 = new EmailAddress("jdoe@bigco.com", "work");
        p.setEmailAddresses(Arrays.asList(ea, ea2));
        return p;
    }

    public boolean compareRoundtripResults(Object expected, Object result) {
        try {
            return XMLUnit.compareXML((String)expected.toString(), (String)result.toString()).similar();
        }
        catch (Exception e) {
            Assert.fail((String)("Failed to compare roudtrip XML strings: " + e.getMessage()));
            return false;
        }
    }
}

