/*
 * Decompiled with CFR 0.152.
 */
package org.mule.routing.filters.xml;

import java.io.InputStream;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;
import org.mule.DefaultMuleMessage;
import org.mule.api.MuleContext;
import org.mule.api.MuleMessage;
import org.mule.module.xml.filters.IsXmlFilter;
import org.mule.module.xml.util.XMLTestUtils;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.util.IOUtils;

public class IsXmlFilterTestCase
extends AbstractMuleTestCase {
    private IsXmlFilter filter;
    private MuleContext muleContext;

    @Before
    public void setUp() {
        this.filter = new IsXmlFilter();
        this.muleContext = (MuleContext)Mockito.mock(MuleContext.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
    }

    @Test
    public void testFilterFalse() throws Exception {
        Assert.assertFalse((boolean)this.filter.accept((MuleMessage)new DefaultMuleMessage((Object)"This is definitely not XML.", this.muleContext)));
    }

    @Test
    public void testFilterFalse2() throws Exception {
        Assert.assertFalse((boolean)this.filter.accept((MuleMessage)new DefaultMuleMessage((Object)"<line>This is almost XML</line><line>This is almost XML</line>", this.muleContext)));
    }

    @Test
    public void testFilterTrue() throws Exception {
        Assert.assertTrue((boolean)this.filter.accept((MuleMessage)new DefaultMuleMessage((Object)"<msg attrib=\"att1\">This is some nice XML!</msg>", this.muleContext)));
    }

    @Test
    public void testFilterBytes() throws Exception {
        byte[] bytes = "<msg attrib=\"att1\">This is some nice XML!</msg>".getBytes();
        Assert.assertTrue((boolean)this.filter.accept((MuleMessage)new DefaultMuleMessage((Object)bytes, this.muleContext)));
    }

    @Test
    public void testFilterNull() throws Exception {
        Assert.assertFalse((boolean)this.filter.accept((MuleMessage)new DefaultMuleMessage(null, this.muleContext)));
    }

    @Test
    public void testFilterLargeXml() throws Exception {
        InputStream is = IOUtils.getResourceAsStream((String)"cdcatalog.xml", ((Object)((Object)this)).getClass());
        Assert.assertNotNull((String)"Test resource not found.", (Object)is);
        String xml = IOUtils.toString((InputStream)is);
        Assert.assertTrue((boolean)this.filter.accept((MuleMessage)new DefaultMuleMessage((Object)xml, this.muleContext)));
    }

    @Test
    public void testFilterLargeXmlCompliantHtml() throws Exception {
        InputStream is = IOUtils.getResourceAsStream((String)"cdcatalog.html", ((Object)((Object)this)).getClass());
        Assert.assertNotNull((String)"Test resource not found.", (Object)is);
        String html = IOUtils.toString((InputStream)is);
        Assert.assertTrue((boolean)this.filter.accept((MuleMessage)new DefaultMuleMessage((Object)html, this.muleContext)));
    }

    @Test
    public void testFilterXmlMessageVariants() throws Exception {
        List<?> list = XMLTestUtils.getXmlMessageVariants("cdcatalog.xml");
        for (Object message : list) {
            Assert.assertTrue((boolean)this.filter.accept((MuleMessage)new DefaultMuleMessage(message, this.muleContext)));
        }
    }
}

