/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.xml.el;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.mule.DefaultMuleEvent;
import org.mule.DefaultMuleMessage;
import org.mule.RequestContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleMessage;
import org.mule.api.expression.ExpressionRuntimeException;
import org.mule.el.context.AbstractELTestCase;
import org.mule.module.xml.xpath.XPathReturnType;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class XPath3FunctionTestCase
extends AbstractELTestCase {
    private static final String ROOT_FOO_BAR = "<root foo=\"bar\"/>";
    private static final String BAR = "bar";

    public XPath3FunctionTestCase(AbstractELTestCase.Variant variant, String optimizer) {
        super(variant, optimizer);
    }

    @Test
    public void fromString() throws Exception {
        this.evaluateFooFromPayload(ROOT_FOO_BAR);
        this.evaluateFooFromFlowVar(ROOT_FOO_BAR);
    }

    @Test
    public void fromStream() throws Exception {
        InputStream payload = (InputStream)Mockito.spy((Object)new ByteArrayInputStream(ROOT_FOO_BAR.getBytes()));
        this.evaluateFooFromPayload(payload);
        ((InputStream)Mockito.verify((Object)payload)).close();
        payload = new ByteArrayInputStream(ROOT_FOO_BAR.getBytes());
        this.evaluateFooFromFlowVar(payload);
    }

    @Test
    public void messagePayloadChangedWhenPayloadConsumed() throws Exception {
        MuleEvent event = XPath3FunctionTestCase.getTestEvent((Object)new ByteArrayInputStream(ROOT_FOO_BAR.getBytes()));
        Assert.assertThat((Object)((String)this.doEvaluate("xpath3('/root/@foo')", event)), (Matcher)CoreMatchers.equalTo((Object)BAR));
        Assert.assertThat((Object)event.getMessage().getPayload(), (Matcher)CoreMatchers.instanceOf(Node.class));
    }

    @Test
    public void returnTypes() throws Exception {
        HashMap<XPathReturnType, Class<String>> types = new HashMap<XPathReturnType, Class<String>>();
        types.put(XPathReturnType.BOOLEAN, Boolean.class);
        types.put(XPathReturnType.NODE, Node.class);
        types.put(XPathReturnType.NODESET, NodeList.class);
        types.put(XPathReturnType.NUMBER, Double.class);
        types.put(XPathReturnType.STRING, String.class);
        MuleEvent event = XPath3FunctionTestCase.getTestEvent((Object)ROOT_FOO_BAR);
        for (Map.Entry entry : types.entrySet()) {
            String expression = String.format("xpath3('/root/@foo', payload, '%s')", ((XPathReturnType)entry.getKey()).name());
            Assert.assertThat((Object)this.doEvaluate(expression, event), (Matcher)CoreMatchers.instanceOf((Class)((Class)entry.getValue())));
        }
    }

    @Test(expected=ExpressionRuntimeException.class)
    public void noArgs() throws Exception {
        this.doEvaluate("xpath3()", XPath3FunctionTestCase.getTestEvent((Object)ROOT_FOO_BAR));
    }

    @Test(expected=ExpressionRuntimeException.class)
    public void tooManyArgs() throws Exception {
        this.doEvaluate("xpath3('/root/@foo', payload, 'STRING', 'one too many')", XPath3FunctionTestCase.getTestEvent((Object)ROOT_FOO_BAR));
    }

    @Test(expected=ExpressionRuntimeException.class)
    public void blankExpression() throws Exception {
        this.doEvaluate("xpath3('')", XPath3FunctionTestCase.getTestEvent((Object)ROOT_FOO_BAR));
    }

    @Test(expected=ExpressionRuntimeException.class)
    public void notAStringExpression() throws Exception {
        this.doEvaluate("xpath3(System.out)", XPath3FunctionTestCase.getTestEvent((Object)ROOT_FOO_BAR));
    }

    @Test
    public void fromDom4jDocument() throws Exception {
        Document document = DocumentHelper.parseText((String)ROOT_FOO_BAR);
        this.evaluateFooFromPayload(document);
        this.evaluateFooFromFlowVar(document);
    }

    @Test
    public void fromW3CDocument() throws Exception {
        org.w3c.dom.Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(new InputSource(new StringReader(ROOT_FOO_BAR)));
        this.evaluateFooFromPayload(document);
        this.evaluateFooFromFlowVar(document);
    }

    @Test
    public void fromXmlStreamReader() throws Exception {
        this.evaluateFooFromPayload(this.getXmlStreamReader());
        this.evaluateFooFromFlowVar(this.getXmlStreamReader());
    }

    public XMLStreamReader getXmlStreamReader() throws XMLStreamException {
        return XMLInputFactory.newInstance().createXMLStreamReader(new StringReader(ROOT_FOO_BAR));
    }

    @Test
    public void parametrized() throws Exception {
        MuleEvent event = XPath3FunctionTestCase.getTestEvent((Object)ROOT_FOO_BAR);
        event.setFlowVariable("foo", (Object)BAR);
        Object result = this.doEvaluate("xpath3('/root[@foo=$foo]', payload, 'NODE')", event);
        Assert.assertThat((Object)result, (Matcher)CoreMatchers.instanceOf(Node.class));
        Assert.assertThat((Object)((Node)result).getAttributes().getNamedItem("foo").getNodeValue(), (Matcher)CoreMatchers.equalTo((Object)BAR));
    }

    @Test
    public void emptyParametrizedResult() throws Exception {
        MuleEvent event = XPath3FunctionTestCase.getTestEvent((Object)ROOT_FOO_BAR);
        event.setFlowVariable("foo", (Object)"not a bar");
        Object result = this.doEvaluate("xpath3('/root[@foo=$foo]', payload, 'NODE')", event);
        Assert.assertThat((Object)result, (Matcher)Is.is((Matcher)CoreMatchers.nullValue()));
    }

    @Test
    public void autoConvertNumericType() throws Exception {
        MuleEvent event = XPath3FunctionTestCase.getTestEvent((Object)"<root foo=\"33\"/>");
        event.setFlowVariable("foo", (Object)33);
        Object result = this.doEvaluate("xpath3('/root[@foo=$foo]', payload, 'NODE')", event);
        Assert.assertThat((Object)result, (Matcher)CoreMatchers.instanceOf(Node.class));
        Assert.assertThat((Object)((Node)result).getAttributes().getNamedItem("foo").getNodeValue(), (Matcher)CoreMatchers.equalTo((Object)"33"));
    }

    private void evaluateFooFromPayload(Object payload) throws Exception {
        DefaultMuleMessage message = new DefaultMuleMessage(payload, muleContext);
        DefaultMuleEvent event = new DefaultMuleEvent((MuleMessage)message, XPath3FunctionTestCase.getTestEvent((Object)""));
        Assert.assertThat((Object)((String)this.doEvaluate("xpath3('/root/@foo')", (MuleEvent)event)), (Matcher)CoreMatchers.equalTo((Object)BAR));
    }

    private void evaluateFooFromFlowVar(Object payload) throws Exception {
        MuleEvent event = XPath3FunctionTestCase.getTestEvent((Object)"");
        event.setFlowVariable("input", payload);
        Assert.assertThat((Object)((String)this.doEvaluate("xpath3('/root/@foo', flowVars['input'])", event)), (Matcher)CoreMatchers.equalTo((Object)BAR));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object doEvaluate(String expression, MuleEvent event) throws Exception {
        RequestContext.setEvent((MuleEvent)event);
        try {
            Object object = this.evaluate(expression, event.getMessage());
            return object;
        }
        finally {
            RequestContext.clear();
        }
    }
}

