/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transformers.xml;

import java.io.InputStream;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.io.DOMReader;
import org.dom4j.io.DOMWriter;
import org.mule.api.endpoint.EndpointBuilder;
import org.mule.api.endpoint.ImmutableEndpoint;
import org.mule.api.endpoint.InboundEndpoint;
import org.mule.api.transformer.Transformer;
import org.mule.endpoint.EndpointURIEndpointBuilder;
import org.mule.module.xml.transformer.DomDocumentToXml;
import org.mule.module.xml.transformer.XmlToDomDocument;
import org.mule.transformer.types.DataTypeFactory;
import org.mule.transformers.xml.AbstractXmlTransformerTestCase;
import org.mule.util.IOUtils;

public class DomXmlTransformerEncodingTestCase
extends AbstractXmlTransformerTestCase {
    private org.w3c.dom.Document srcData;
    private String resultData;

    protected void doSetUp() throws Exception {
        Document dom4jDoc = DocumentHelper.parseText((String)IOUtils.toString((InputStream)IOUtils.getResourceAsStream((String)"cdcatalog-utf-8.xml", ((Object)((Object)this)).getClass()), (String)"UTF-8"));
        this.srcData = new DOMWriter().write(dom4jDoc);
        this.resultData = IOUtils.toString((InputStream)IOUtils.getResourceAsStream((String)"cdcatalog-us-ascii.xml", ((Object)((Object)this)).getClass()), (String)"US-ASCII");
    }

    public Transformer getTransformer() throws Exception {
        Transformer trans = (Transformer)this.createObject(DomDocumentToXml.class);
        trans.setReturnDataType(DataTypeFactory.STRING);
        EndpointURIEndpointBuilder builder = new EndpointURIEndpointBuilder("test://test", muleContext);
        builder.setEncoding("US-ASCII");
        InboundEndpoint endpoint = muleContext.getEndpointFactory().getInboundEndpoint((EndpointBuilder)builder);
        trans.setEndpoint((ImmutableEndpoint)endpoint);
        return trans;
    }

    public Transformer getRoundTripTransformer() throws Exception {
        XmlToDomDocument trans = (XmlToDomDocument)this.createObject(XmlToDomDocument.class);
        trans.setReturnDataType(DataTypeFactory.create(org.w3c.dom.Document.class));
        return trans;
    }

    public Object getTestData() {
        return this.srcData;
    }

    public Object getResultData() {
        return this.resultData;
    }

    @Override
    public boolean compareResults(Object expected, Object result) {
        if (expected instanceof org.w3c.dom.Document) {
            expected = new DOMReader().read((org.w3c.dom.Document)expected).asXML();
            result = new DOMReader().read((org.w3c.dom.Document)result).asXML();
        }
        return super.compareResults(expected, result);
    }
}

