/*
 * Decompiled with CFR 0.152.
 */
package org.mule.routing.filters.xml;

import java.io.InputStream;
import java.io.StringReader;
import java.util.HashMap;
import java.util.List;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.stream.XMLStreamReader;
import org.apache.commons.io.IOUtils;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.junit.Assert;
import org.junit.Test;
import org.mule.DefaultMuleMessage;
import org.mule.api.MuleMessage;
import org.mule.module.xml.filters.JXPathFilter;
import org.mule.module.xml.util.XMLTestUtils;
import org.mule.routing.filters.xml.Dummy;
import org.mule.tck.junit4.AbstractMuleContextTestCase;
import org.xml.sax.InputSource;

public class JXPathFilterTestCase
extends AbstractMuleContextTestCase {
    private String xmlStringInput = null;
    private String xmlStringInputNS = null;
    private Document dom4jDocumentInput = null;
    private Document dom4jDocumentInputNS = null;
    private org.w3c.dom.Document w3cDocumentInput = null;
    private org.w3c.dom.Document w3cDocumentInputNS = null;
    private JXPathFilter simpleFilter = null;
    private JXPathFilter nsAwareFilter = null;

    protected void doSetUp() throws Exception {
        ClassLoader currentClassLoader = Thread.currentThread().getContextClassLoader();
        InputStream is = currentClassLoader.getResourceAsStream("cdcatalog.xml");
        Assert.assertNotNull((String)"Test resource 'cdcatalog.xml' not found.", (Object)is);
        this.xmlStringInput = IOUtils.toString((InputStream)is);
        this.dom4jDocumentInput = DocumentHelper.parseText((String)this.xmlStringInput);
        this.w3cDocumentInput = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(new InputSource(new StringReader(this.xmlStringInput)));
        this.simpleFilter = new JXPathFilter();
        this.simpleFilter.setMuleContext(muleContext);
        is = currentClassLoader.getResourceAsStream("cdcatalogNS.xml");
        Assert.assertNotNull((String)"Test resource 'cdcatalogNS.xml' not found.", (Object)is);
        this.xmlStringInputNS = IOUtils.toString((InputStream)is);
        this.dom4jDocumentInputNS = DocumentHelper.parseText((String)this.xmlStringInputNS);
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setNamespaceAware(true);
        this.w3cDocumentInputNS = dbf.newDocumentBuilder().parse(new InputSource(new StringReader(this.xmlStringInputNS)));
        this.nsAwareFilter = new JXPathFilter();
        HashMap<String, String> namespaces = new HashMap<String, String>();
        namespaces.put("nsone", "http://one.org");
        namespaces.put("nstwo", "http://two.org");
        this.nsAwareFilter.setNamespaces(namespaces);
        this.nsAwareFilter.setMuleContext(muleContext);
        muleContext.start();
    }

    @Test
    public void testBogusExpression() throws Exception {
        try {
            JXPathFilter myFilter = (JXPathFilter)this.createObject(JXPathFilter.class);
            myFilter.setPattern("foo/bar/");
            myFilter.accept((MuleMessage)new DefaultMuleMessage((Object)this.xmlStringInput, muleContext));
            Assert.fail((String)"Invalid XPath should have thrown an exception");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void doTestExpectedValueFilter(Object xmlData) throws Exception {
        this.simpleFilter.setPattern("catalog/cd[3]/title");
        this.simpleFilter.setExpectedValue("Greatest Hits");
        Assert.assertTrue((boolean)this.simpleFilter.accept((MuleMessage)new DefaultMuleMessage(xmlData, muleContext)));
    }

    private void doTestBooleanFilter1(Object xmlData) throws Exception {
        this.simpleFilter.setPattern("(catalog/cd[3]/title) ='Greatest Hits'");
        Assert.assertTrue((boolean)this.simpleFilter.accept((MuleMessage)new DefaultMuleMessage(xmlData, muleContext)));
    }

    private void doTestBooleanFilter2(Object xmlData) throws Exception {
        this.simpleFilter.setPattern("count(catalog/cd) = 26");
        Assert.assertTrue((boolean)this.simpleFilter.accept((MuleMessage)new DefaultMuleMessage(xmlData, muleContext)));
    }

    private void doTestExpectedValueFilterNS(Object xmlData) throws Exception {
        this.nsAwareFilter.setPattern("nsone:catalog/nstwo:cd[3]/title");
        this.nsAwareFilter.setExpectedValue("Greatest Hits");
        Assert.assertTrue((boolean)this.nsAwareFilter.accept((MuleMessage)new DefaultMuleMessage(xmlData, muleContext)));
    }

    private void doTestBooleanFilter1NS(Object xmlData) throws Exception {
        this.nsAwareFilter.setPattern("(nsone:catalog/nstwo:cd[3]/title) ='Greatest Hits'");
        Assert.assertTrue((boolean)this.nsAwareFilter.accept((MuleMessage)new DefaultMuleMessage(xmlData, muleContext)));
    }

    private void doTestBooleanFilter2NS(Object xmlData) throws Exception {
        this.nsAwareFilter.setPattern("count(nsone:catalog/nstwo:cd) = 26");
        Assert.assertTrue((boolean)this.nsAwareFilter.accept((MuleMessage)new DefaultMuleMessage(xmlData, muleContext)));
    }

    @Test
    public void testFilterOnObject() throws Exception {
        Dummy d = new Dummy();
        d.setId(10);
        d.setContent("hello");
        this.simpleFilter.setPattern("id=10 and content='hello'");
        Assert.assertTrue((boolean)this.simpleFilter.accept((MuleMessage)new DefaultMuleMessage((Object)d, muleContext)));
    }

    @Test
    public void testExpectedValueFilterXmlString() throws Exception {
        this.doTestExpectedValueFilter(this.xmlStringInput);
    }

    @Test
    public void testExpectedValueFilterXmlByteArray() throws Exception {
        this.doTestExpectedValueFilter(this.xmlStringInput.getBytes());
    }

    @Test
    public void testBooleanFilter1XmlString() throws Exception {
        this.doTestBooleanFilter1(this.xmlStringInput);
    }

    @Test
    public void testBooleanFilter2XmlString() throws Exception {
        this.doTestBooleanFilter2(this.xmlStringInput);
    }

    @Test
    public void testExpectedValueFilterDom4JDocument() throws Exception {
        this.doTestExpectedValueFilter(this.dom4jDocumentInput);
    }

    @Test
    public void testBooleanFilter1Dom4JDocument() throws Exception {
        this.doTestBooleanFilter1(this.dom4jDocumentInput);
    }

    @Test
    public void testBooleanFilter2Dom4JDocument() throws Exception {
        this.doTestBooleanFilter2(this.dom4jDocumentInput);
    }

    @Test
    public void testExpectedValueFilterW3cDocument() throws Exception {
        this.doTestExpectedValueFilter(this.w3cDocumentInput);
    }

    @Test
    public void testBooleanFilter1W3cDocument() throws Exception {
        this.doTestBooleanFilter1(this.w3cDocumentInput);
    }

    @Test
    public void testBooleanFilter2W3cDocument() throws Exception {
        this.doTestBooleanFilter2(this.w3cDocumentInput);
    }

    @Test
    public void testExpectedValueFilterXmlStringNS() throws Exception {
        this.doTestExpectedValueFilterNS(this.xmlStringInputNS);
    }

    @Test
    public void testBooleanFilter1XmlStringNS() throws Exception {
        this.doTestBooleanFilter1NS(this.xmlStringInputNS);
    }

    @Test
    public void testBooleanFilter2XmlStringNS() throws Exception {
        this.doTestBooleanFilter2NS(this.xmlStringInputNS);
    }

    @Test
    public void testExpectedValueFilterDom4JDocumentNS() throws Exception {
        this.doTestExpectedValueFilterNS(this.dom4jDocumentInputNS);
    }

    @Test
    public void testBooleanFilter1Dom4JDocumentNS() throws Exception {
        this.doTestBooleanFilter1NS(this.dom4jDocumentInputNS);
    }

    @Test
    public void testBooleanFilter2Dom4JDocumentNS() throws Exception {
        this.doTestBooleanFilter2NS(this.dom4jDocumentInputNS);
    }

    @Test
    public void testExpectedValueFilterW3cDocumentNS() throws Exception {
        this.doTestExpectedValueFilterNS(this.w3cDocumentInputNS);
    }

    @Test
    public void testBooleanFilter1W3cDocumentNS() throws Exception {
        this.doTestBooleanFilter1NS(this.w3cDocumentInputNS);
    }

    @Test
    public void testBooleanFilter2W3cDocumentNS() throws Exception {
        this.doTestBooleanFilter2NS(this.w3cDocumentInputNS);
    }

    @Test
    public void testSimpleFilterXmlMessageVariants() throws Exception {
        this.simpleFilter.setPattern("catalog/cd[3]/title");
        this.simpleFilter.setExpectedValue("Greatest Hits");
        List<?> list = XMLTestUtils.getXmlMessageVariants("cdcatalog.xml");
        for (Object msg : list) {
            if (msg instanceof XMLStreamReader) continue;
            Assert.assertTrue((String)("Test failed for message type: " + msg.getClass()), (boolean)this.simpleFilter.accept((MuleMessage)new DefaultMuleMessage(msg, muleContext)));
        }
    }
}

