/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.xml.util;

import java.io.File;
import java.io.InputStream;
import java.net.URL;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.Source;
import org.dom4j.Document;
import org.junit.Assert;
import org.junit.Test;
import org.mule.module.xml.util.XMLTestUtils;
import org.mule.module.xml.util.XMLUtils;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.util.IOUtils;
import org.xml.sax.InputSource;

public class XmlUtilsTestCase
extends AbstractMuleTestCase {
    private static final String SIMPLE_XML_RESOURCE = "simple.xml";
    private static final String SIMPLE_XML_CONTENT = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<just>testing</just>";

    @Test
    public void testConvertsToW3cDocumentFromDom4jDocument() throws Exception {
        Document document = XMLTestUtils.toDom4jDocument(SIMPLE_XML_RESOURCE);
        this.assertToW3cDocumentSuccessfullyConvertsPayload(document);
    }

    @Test
    public void testConvertsToW3cDocumentFromW3cDocument() throws Exception {
        org.w3c.dom.Document document = XMLTestUtils.toW3cDocument(SIMPLE_XML_RESOURCE);
        this.assertToW3cDocumentSuccessfullyConvertsPayload(document);
    }

    @Test
    public void testConvertsToW3cDocumentFromInputSource() throws Exception {
        InputSource payload = XMLTestUtils.toInputSource(SIMPLE_XML_RESOURCE);
        this.assertToW3cDocumentSuccessfullyConvertsPayload(payload);
    }

    @Test
    public void testConvertsToW3cDocumentFromSource() throws Exception {
        Source payload = XMLTestUtils.toSource(SIMPLE_XML_RESOURCE);
        this.assertToW3cDocumentSuccessfullyConvertsPayload(payload);
    }

    @Test
    public void testConvertsToW3cDocumentFromXmlStreamReader() throws Exception {
        XMLStreamReader payload = XMLTestUtils.toXmlStreamReader(SIMPLE_XML_RESOURCE);
        this.assertToW3cDocumentSuccessfullyConvertsPayload(payload);
    }

    @Test
    public void testConvertsToW3cDocumentFromInputStream() throws Exception {
        InputStream payload = XMLTestUtils.toInputStream(SIMPLE_XML_RESOURCE);
        this.assertToW3cDocumentSuccessfullyConvertsPayload(payload);
    }

    @Test
    public void testConvertsToW3cDocumentFromString() throws Exception {
        String payload = XMLTestUtils.toString(SIMPLE_XML_RESOURCE);
        this.assertToW3cDocumentSuccessfullyConvertsPayload(payload);
    }

    @Test
    public void testConvertsToW3cDocumentFromByteArray() throws Exception {
        byte[] payload = XMLTestUtils.toString(SIMPLE_XML_RESOURCE).getBytes();
        this.assertToW3cDocumentSuccessfullyConvertsPayload(payload);
    }

    @Test
    public void testConvertsToW3cDocumentFromFile() throws Exception {
        URL asUrl = IOUtils.getResourceAsUrl((String)SIMPLE_XML_RESOURCE, ((Object)((Object)this)).getClass());
        File payload = new File(asUrl.getFile());
        this.assertToW3cDocumentSuccessfullyConvertsPayload(payload);
    }

    private void assertToW3cDocumentSuccessfullyConvertsPayload(Object payload) throws Exception {
        org.w3c.dom.Document document = XMLUtils.toW3cDocument((Object)payload);
        String actualXml = XMLUtils.toXml((org.w3c.dom.Document)document);
        Assert.assertEquals((Object)SIMPLE_XML_CONTENT, (Object)actualXml);
    }
}

