/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transformers.xml;

import java.io.IOException;
import java.io.OutputStream;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.junit.Test;
import org.mule.api.MuleEvent;
import org.mule.api.transformer.DataType;
import org.mule.api.transformer.Transformer;
import org.mule.api.transport.OutputHandler;
import org.mule.module.xml.transformer.XmlToDomDocument;
import org.mule.module.xml.transformer.XmlToXMLStreamReader;
import org.mule.module.xml.util.XMLUtils;
import org.mule.transformers.xml.AbstractXmlTransformerTestCase;

public class XmlToXMLStreamReaderTestCase
extends AbstractXmlTransformerTestCase {
    private static final String TEST_XML = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><test>TEST_MESSAGE</test>";

    public Transformer getTransformer() throws Exception {
        return (Transformer)this.createObject(XmlToXMLStreamReader.class);
    }

    public Transformer getRoundTripTransformer() throws Exception {
        Transformer t = (Transformer)this.createObject(XmlToDomDocument.class);
        t.setReturnDataType(DataType.STRING_DATA_TYPE);
        return t;
    }

    public Object getTestData() {
        return TEST_XML;
    }

    public Object getResultData() {
        try {
            return XMLUtils.toXMLStreamReader((XMLInputFactory)XMLInputFactory.newFactory(), (Object)TEST_XML);
        }
        catch (XMLStreamException e) {
            throw new RuntimeException(e);
        }
    }

    @Test
    public void supportsOutputHandlerAsSourceType() throws Exception {
        OutputHandler outputHandler = new OutputHandler(){

            public void write(MuleEvent event, OutputStream out) throws IOException {
                out.write(XmlToXMLStreamReaderTestCase.TEST_XML.getBytes());
            }
        };
        XMLStreamReader result = (XMLStreamReader)this.getTransformer().transform((Object)outputHandler);
        this.compareResults(this.getResultData(), result);
    }
}

