/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.xml.filters;

import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import javax.xml.stream.XMLInputFactory;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.api.MuleMessage;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.routing.filter.Filter;
import org.mule.config.i18n.CoreMessages;
import org.mule.module.xml.filters.AbstractJaxpFilter;
import org.mule.module.xml.transformer.DelayedResult;
import org.mule.module.xml.util.MuleResourceResolver;
import org.mule.module.xml.util.XMLUtils;
import org.mule.util.IOUtils;
import org.mule.util.StringUtils;
import org.w3c.dom.ls.LSResourceResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;

public class SchemaValidationFilter
extends AbstractJaxpFilter
implements Filter,
Initialisable {
    public static final String DEFAULT_SCHEMA_LANGUAGE = "http://www.w3.org/2001/XMLSchema";
    protected transient Log logger = LogFactory.getLog(this.getClass());
    private String schemaLocations;
    private String schemaLanguage = "http://www.w3.org/2001/XMLSchema";
    private Schema schemaObject;
    private ErrorHandler errorHandler;
    private Map<String, Boolean> validatorFeatures;
    private Map<String, Object> validatorProperties;
    private LSResourceResolver resourceResolver;
    private boolean useStaxSource = false;
    private boolean returnResult = true;
    private XMLInputFactory xmlInputFactory = XMLInputFactory.newInstance();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean accept(MuleMessage message) {
        Source source;
        try {
            source = this.loadSource(message);
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            if (this.logger.isInfoEnabled()) {
                this.logger.info((Object)"SchemaValidationFilter rejected a message because there was a problem interpreting the payload as XML.", (Throwable)e);
            }
            return false;
        }
        if (source == null) {
            if (this.logger.isInfoEnabled()) {
                this.logger.info((Object)"SchemaValidationFilter rejected a message because the XML source was null.");
            }
            return false;
        }
        DOMResult result = null;
        try {
            if (this.returnResult) {
                result = new DOMResult();
                this.createValidator().validate(source, result);
            } else {
                this.createValidator().validate(source);
            }
        }
        catch (SAXException e) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"SchemaValidationFilter rejected a message because it apparently failed to validate against the schema.", (Throwable)e);
            }
            boolean bl = false;
            return bl;
        }
        catch (IOException e) {
            if (this.logger.isInfoEnabled()) {
                this.logger.info((Object)"SchemaValidationFilter rejected a message because there was a problem reading the XML.", (Throwable)e);
            }
            boolean bl = false;
            return bl;
        }
        finally {
            if (result != null && result.getNode() != null) {
                message.setPayload((Object)result.getNode());
            }
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)"SchemaValidationFilter accepted the message.");
        }
        return true;
    }

    protected Object getDelayedResult(final Source source) {
        return new DelayedResult(){
            private String systemId;

            @Override
            public void write(Result result) throws Exception {
                SchemaValidationFilter.this.createValidator().validate(source, result);
            }

            @Override
            public String getSystemId() {
                return this.systemId;
            }

            @Override
            public void setSystemId(String systemId) {
                this.systemId = systemId;
            }
        };
    }

    protected Source loadSource(MuleMessage msg) throws Exception {
        Object payload = msg.getPayload();
        if (this.returnResult) {
            payload = this.toDOMNode(payload);
        }
        return XMLUtils.toXmlSource(this.getXMLInputFactory(), this.isUseStaxSource(), payload);
    }

    @Override
    public void initialise() throws InitialisationException {
        super.initialise();
        if (this.getSchemaObject() == null) {
            Schema schema;
            if (this.schemaLocations == null) {
                throw new InitialisationException(CoreMessages.objectIsNull((String)"schemaLocations"), (Initialisable)this);
            }
            String[] split = StringUtils.splitAndTrim((String)this.schemaLocations, (String)",");
            Source[] schemas = new Source[split.length];
            for (int i = 0; i < split.length; ++i) {
                InputStream schemaStream;
                String loc = split[i];
                try {
                    schemaStream = this.loadSchemaStream(loc);
                }
                catch (IOException e) {
                    throw new InitialisationException((Throwable)e, (Initialisable)this);
                }
                if (schemaStream == null) {
                    throw new InitialisationException(CoreMessages.failedToLoad((String)loc), (Initialisable)this);
                }
                schemas[i] = new StreamSource(schemaStream);
            }
            SchemaFactory schemaFactory = SchemaFactory.newInstance(this.getSchemaLanguage());
            if (this.logger.isInfoEnabled()) {
                this.logger.info((Object)("Schema factory implementation: " + schemaFactory));
            }
            if (this.errorHandler != null) {
                schemaFactory.setErrorHandler(this.errorHandler);
            }
            if (this.resourceResolver == null) {
                this.resourceResolver = new MuleResourceResolver();
            }
            schemaFactory.setResourceResolver(this.resourceResolver);
            try {
                schema = schemaFactory.newSchema(schemas);
            }
            catch (SAXException e) {
                throw new InitialisationException((Throwable)e, (Initialisable)this);
            }
            this.setSchemaObject(schema);
        }
        if (this.getSchemaObject() == null) {
            throw new InitialisationException(CoreMessages.objectIsNull((String)"schemaObject"), (Initialisable)this);
        }
    }

    protected InputStream loadSchemaStream(String schemaLocation) throws IOException {
        return IOUtils.getResourceAsStream((String)schemaLocation, this.getClass());
    }

    public Validator createValidator() throws SAXException {
        Validator validator = this.getSchemaObject().newValidator();
        if (this.validatorFeatures != null) {
            for (Map.Entry<String, Object> entry : this.validatorFeatures.entrySet()) {
                validator.setFeature(entry.getKey(), (Boolean)entry.getValue());
            }
        }
        if (this.validatorProperties != null) {
            for (Map.Entry<String, Object> entry : this.validatorProperties.entrySet()) {
                validator.setProperty(entry.getKey(), entry.getValue());
            }
        }
        return validator;
    }

    public String getSchemaLocations() {
        return this.schemaLocations;
    }

    public void setSchemaLocations(String schemaLocations) {
        this.schemaLocations = schemaLocations;
    }

    public String getSchemaLanguage() {
        return this.schemaLanguage;
    }

    public void setSchemaLanguage(String schemaLanguage) {
        this.schemaLanguage = schemaLanguage;
    }

    public Schema getSchemaObject() {
        return this.schemaObject;
    }

    public void setSchemaObject(Schema schemaObject) {
        this.schemaObject = schemaObject;
    }

    public ErrorHandler getErrorHandler() {
        return this.errorHandler;
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }

    public LSResourceResolver getResourceResolver() {
        return this.resourceResolver;
    }

    public void setResourceResolver(LSResourceResolver resourceResolver) {
        this.resourceResolver = resourceResolver;
    }

    public Map<String, Boolean> getValidatorFeatures() {
        return this.validatorFeatures;
    }

    public void setValidatorFeatures(Map<String, Boolean> validatorFeatures) {
        this.validatorFeatures = validatorFeatures;
    }

    public Map<String, Object> getValidatorProperties() {
        return this.validatorProperties;
    }

    public void setValidatorProperties(Map<String, Object> validatorProperties) {
        this.validatorProperties = validatorProperties;
    }

    public XMLInputFactory getXMLInputFactory() {
        return this.xmlInputFactory;
    }

    public void setXMLInputFactory(XMLInputFactory xmlInputFactory) {
        this.xmlInputFactory = xmlInputFactory;
    }

    public boolean isUseStaxSource() {
        return this.useStaxSource;
    }

    public void setUseStaxSource(boolean useStaxSource) {
        this.useStaxSource = useStaxSource;
    }

    public boolean isReturnResult() {
        return this.returnResult;
    }

    public void setReturnResult(boolean returnResult) {
        this.returnResult = returnResult;
    }
}

