/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.xml.el;

import com.google.common.base.Joiner;
import com.google.common.base.Supplier;
import org.apache.commons.lang.StringUtils;
import org.mule.DefaultMuleMessage;
import org.mule.RequestContext;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleMessage;
import org.mule.api.MuleRuntimeException;
import org.mule.api.el.ExpressionLanguageContext;
import org.mule.api.el.ExpressionLanguageFunction;
import org.mule.api.registry.RegistrationException;
import org.mule.api.transformer.DataType;
import org.mule.el.context.MessageContext;
import org.mule.module.xml.util.NamespaceManager;
import org.mule.module.xml.util.XMLUtils;
import org.mule.module.xml.xpath.SaxonXpathEvaluator;
import org.mule.module.xml.xpath.XPathEvaluator;
import org.mule.module.xml.xpath.XPathReturnType;
import org.mule.transformer.TransformerUtils;
import org.mule.transformer.types.DataTypeFactory;
import org.mule.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class XPath3Function
implements ExpressionLanguageFunction {
    private static final Logger LOGGER = LoggerFactory.getLogger(XPath3Function.class);
    private static final XPathReturnType DEFAULT_RETURN_TYPE = XPathReturnType.STRING;
    private static final DataType<?>[] SUPPORTED_TYPES = new DataType[]{DataTypeFactory.create(Document.class), DataTypeFactory.create(Node.class)};
    private static final String SUPPORTED_TYPES_AS_STRING = Joiner.on((char)',').join((Object[])SUPPORTED_TYPES);
    private final MuleContext muleContext;
    private XPathEvaluator xpathEvaluator;
    private Supplier<XPathEvaluator> xpathEvaluatorSupplier = new LookupEvaluatorSupplier();

    XPath3Function(MuleContext muleContext) {
        this.muleContext = muleContext;
    }

    public Object call(Object[] params, ExpressionLanguageContext context) {
        this.validateParams(params);
        MessageContext ctx = (MessageContext)context.getVariable("message");
        String xpathExpression = this.getXpathExpression(params);
        XPathReturnType returnType = this.getReturnType(params);
        MuleEvent event = this.getMuleEvent(context);
        Object input = this.getInput(params, event);
        try {
            Node node = this.toDOMNode(input, event);
            Object result = ((XPathEvaluator)this.xpathEvaluatorSupplier.get()).evaluate(xpathExpression, node, returnType, event);
            MuleMessage message = event.getMessage();
            if (input == message.getPayload() && ((DefaultMuleMessage)message).isConsumable()) {
                ctx.setPayload((Object)node);
            }
            return result;
        }
        catch (Exception e) {
            throw new MuleRuntimeException((Throwable)e);
        }
    }

    private MuleEvent getMuleEvent(ExpressionLanguageContext context) {
        MuleEvent event = (MuleEvent)context.getVariable("_muleEvent");
        if (event == null) {
            event = RequestContext.getEvent();
        }
        Preconditions.checkState((event != null ? 1 : 0) != 0, (String)"Could not obtain MuleEvent");
        return event;
    }

    private Node toDOMNode(Object input, MuleEvent event) throws Exception {
        if (input == null) {
            throw new IllegalArgumentException("Can't evaluate an XPath expression over a null input");
        }
        Node node = XMLUtils.toDOMNode(input, event);
        if (node == null) {
            node = (Node)TransformerUtils.transformToAny((Object)input, (MuleContext)this.muleContext, SUPPORTED_TYPES);
        }
        if (node == null) {
            throw new IllegalArgumentException(String.format("Could not transform input of type '%s' to a supported one. Supported types are '%s'", input.getClass().getName(), SUPPORTED_TYPES_AS_STRING));
        }
        return node;
    }

    private Object getInput(Object[] params, MuleEvent event) {
        if (params.length >= 2) {
            return params[1];
        }
        return event.getMessage().getPayload();
    }

    private void validateParams(Object[] params) {
        Preconditions.checkArgument((params.length > 0 && params.length <= 3 ? 1 : 0) != 0, (String)String.format("xpath3() function accepts up to 3 arguments, but %s were provided instead", params.length));
    }

    private String getXpathExpression(Object[] params) {
        Preconditions.checkArgument((params[0] != null ? 1 : 0) != 0, (String)"XPath expression cannot be null");
        Preconditions.checkArgument((boolean)(params[0] instanceof String), (String)"XPath expression must be a String");
        String expression = (String)params[0];
        Preconditions.checkArgument((!StringUtils.isBlank((String)expression) ? 1 : 0) != 0, (String)"XPath expression cannot be blank");
        return expression;
    }

    private XPathReturnType getReturnType(Object[] params) {
        if (params.length >= 3) {
            Object returnType = params[2];
            if (returnType == null) {
                return DEFAULT_RETURN_TYPE;
            }
            Preconditions.checkArgument((boolean)(returnType instanceof String), (String)"returnType argument must be of type String");
            try {
                return XPathReturnType.valueOf((String)returnType);
            }
            catch (Exception e) {
                throw new IllegalArgumentException(returnType + " is not a valid XPath return type", e);
            }
        }
        return DEFAULT_RETURN_TYPE;
    }

    private class FastEvaluatorSupplier
    implements Supplier<XPathEvaluator> {
        private FastEvaluatorSupplier() {
        }

        public XPathEvaluator get() {
            return XPath3Function.this.xpathEvaluator;
        }
    }

    private class LookupEvaluatorSupplier
    implements Supplier<XPathEvaluator> {
        private LookupEvaluatorSupplier() {
        }

        public synchronized XPathEvaluator get() {
            if (XPath3Function.this.xpathEvaluator == null) {
                XPath3Function.this.xpathEvaluator = new SaxonXpathEvaluator();
                try {
                    NamespaceManager namespaceManager = (NamespaceManager)XPath3Function.this.muleContext.getRegistry().lookupObject(NamespaceManager.class);
                    if (namespaceManager != null) {
                        XPath3Function.this.xpathEvaluator.registerNamespaces(namespaceManager);
                    }
                }
                catch (RegistrationException e) {
                    LOGGER.debug("No namespace manager found. Will not register any namespaces");
                }
                XPath3Function.this.xpathEvaluatorSupplier = new FastEvaluatorSupplier();
            }
            return XPath3Function.this.xpathEvaluator;
        }
    }
}

