/*
 * Decompiled with CFR 0.152.
 */
package org.mule.xml.util.properties;

import java.net.MalformedURLException;
import java.util.HashMap;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.mule.DefaultMuleMessage;
import org.mule.api.MuleMessage;
import org.mule.api.registry.RegistrationException;
import org.mule.module.xml.expression.JXPathExpressionEvaluator;
import org.mule.module.xml.util.NamespaceManager;
import org.mule.tck.junit4.AbstractMuleContextTestCase;
import org.mule.tck.testmodels.fruit.Apple;
import org.mule.tck.testmodels.fruit.Banana;
import org.mule.tck.testmodels.fruit.FruitBowl;
import org.mule.util.IOUtils;
import org.mule.util.StringUtils;

public class JXPathExpressionEvaluatorTestCase
extends AbstractMuleContextTestCase {
    private static final String XML_USING_UNDEFINED_NAMESPACE = "<root xmlns:z=\"http://www.w3schools.com/furniture\"><z:table><z:name>African Coffee Table</z:name><z:width>80</z:width><z:length>120</z:length></z:table></root>";

    @Test
    public void testBean() {
        Apple apple = new Apple();
        apple.wash();
        FruitBowl payload = new FruitBowl(apple, new Banana());
        DefaultMuleMessage msg = new DefaultMuleMessage((Object)payload, muleContext);
        JXPathExpressionEvaluator e = new JXPathExpressionEvaluator();
        Object value = e.evaluate("apple/washed", (MuleMessage)msg);
        Assert.assertNotNull((Object)value);
        Assert.assertTrue((boolean)(value instanceof Boolean));
        Assert.assertTrue((boolean)((Boolean)value));
        value = e.evaluate("bar", (MuleMessage)msg);
        Assert.assertNull((Object)value);
    }

    @Test
    public void testXmlContainingNoNameSpaces() throws MalformedURLException {
        String payload = "<?xml version=\"1.0\" ?><address><street>Orchard Road</street></address>";
        DefaultMuleMessage msg = new DefaultMuleMessage((Object)payload, muleContext);
        JXPathExpressionEvaluator e = new JXPathExpressionEvaluator();
        Object value = e.evaluate("/address/street", (MuleMessage)msg);
        Assert.assertTrue((boolean)(value instanceof String));
        Assert.assertEquals((Object)"Orchard Road", (Object)value);
    }

    @Test
    public void testXmlIfNameSpaceIsDefinedWithTheSamePrefix() throws MalformedURLException {
        String payload = "<root xmlns:f=\"http://www.w3schools.com/furniture\"><f:table><f:name>African Coffee Table</f:name><f:width>80</f:width><f:length>120</f:length></f:table></root>";
        DefaultMuleMessage msg = new DefaultMuleMessage((Object)payload, muleContext);
        JXPathExpressionEvaluator e = new JXPathExpressionEvaluator();
        Object value = e.evaluate("//f:table/f:name", (MuleMessage)msg);
        Assert.assertTrue((boolean)(value instanceof String));
        Assert.assertEquals((Object)"African Coffee Table", (Object)value);
    }

    @Test
    public void testXmlWithInvalidNameSpaceIfNameSpaceAliasIsUndefined() throws MalformedURLException {
        String xpathExpression = "//f:table/f:name";
        DefaultMuleMessage msg = new DefaultMuleMessage((Object)XML_USING_UNDEFINED_NAMESPACE, muleContext);
        JXPathExpressionEvaluator e = new JXPathExpressionEvaluator();
        Object value = e.evaluate("//f:table/f:name", (MuleMessage)msg);
        Assert.assertNull((Object)value);
    }

    @Test
    public void testXmlWithInvalidNameSpaceIfNameSpaceAliasIsDefined() throws MalformedURLException, RegistrationException {
        NamespaceManager namespaceManager = new NamespaceManager();
        HashMap<String, String> namespaces = new HashMap<String, String>();
        namespaces.put("f", "http://www.w3schools.com/furniture");
        namespaceManager.setNamespaces(namespaces);
        muleContext.getRegistry().registerObject("_muleNamespaceManager", (Object)namespaceManager);
        DefaultMuleMessage msg = new DefaultMuleMessage((Object)XML_USING_UNDEFINED_NAMESPACE, muleContext);
        JXPathExpressionEvaluator e = new JXPathExpressionEvaluator();
        e.setMuleContext(muleContext);
        Object value = e.evaluate("//f:table/f:name", (MuleMessage)msg);
        Assert.assertTrue((boolean)(value instanceof String));
        Assert.assertEquals((Object)"African Coffee Table", (Object)value);
    }

    @Test
    public void assertNoXXEVulnerable() throws Exception {
        String xxe = String.format("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<!DOCTYPE spi_doc_type[ <!ENTITY spi_entity_ref SYSTEM 'file:%s'>]>\n<root>\n<elem>&spi_entity_ref;</elem>\n<something/>\n</root>", IOUtils.getResourceAsUrl((String)"xxe-passwd.txt", ((Object)((Object)this)).getClass()).getPath());
        JXPathExpressionEvaluator evaluator = new JXPathExpressionEvaluator();
        evaluator.setMuleContext(muleContext);
        Object value = evaluator.evaluate(".", JXPathExpressionEvaluatorTestCase.getTestEvent((Object)xxe).getMessage());
        Assert.assertThat((Object)value, (Matcher)CoreMatchers.instanceOf(String.class));
        Assert.assertThat((Object)StringUtils.isBlank((String)((String)value)), (Matcher)CoreMatchers.is((Object)true));
    }
}

