/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.xml.config;

import org.junit.Assert;
import org.junit.Test;
import org.mule.api.endpoint.EndpointBuilder;
import org.mule.api.endpoint.InboundEndpoint;
import org.mule.api.routing.filter.Filter;
import org.mule.api.transformer.Transformer;
import org.mule.jaxb.model.Person;
import org.mule.module.xml.filters.JXPathFilter;
import org.mule.module.xml.filters.JaxenFilter;
import org.mule.module.xml.filters.SchemaValidationFilter;
import org.mule.module.xml.transformer.JXPathExtractor;
import org.mule.module.xml.transformer.jaxb.JAXBMarshallerTransformer;
import org.mule.module.xml.transformer.jaxb.JAXBUnmarshallerTransformer;
import org.mule.module.xml.util.NamespaceManager;
import org.mule.tck.junit4.FunctionalTestCase;
import org.w3c.dom.ls.LSInput;
import org.w3c.dom.ls.LSResourceResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class XmlNamespaceTestCase
extends FunctionalTestCase {
    public XmlNamespaceTestCase() {
        this.setDisposeContextPerClass(true);
    }

    protected String getConfigFile() {
        return "xml-namespace-config.xml";
    }

    @Test
    public void testGlobalNamespaces() throws Exception {
        NamespaceManager manager = (NamespaceManager)muleContext.getRegistry().lookupObject(NamespaceManager.class);
        Assert.assertNotNull((Object)manager);
        Assert.assertTrue((boolean)manager.isIncludeConfigNamespaces());
        Assert.assertEquals((long)5L, (long)manager.getNamespaces().size());
    }

    @Test
    public void testJXPathFilterConfig() throws Exception {
        EndpointBuilder epb = muleContext.getRegistry().lookupEndpointBuilder("test.ep1");
        InboundEndpoint ep = epb.buildInboundEndpoint();
        Assert.assertNotNull((Object)ep.getFilter());
        Assert.assertTrue((boolean)(ep.getFilter() instanceof JXPathFilter));
        JXPathFilter filter = (JXPathFilter)ep.getFilter();
        Assert.assertEquals((Object)"/bar:foo/bar:bar", (Object)filter.getPattern());
        Assert.assertEquals((long)6L, (long)filter.getNamespaces().size());
        Assert.assertEquals((Object)"http://bar.com", filter.getNamespaces().get("bar"));
    }

    @Test
    public void testJaxenFilterConfig() throws Exception {
        EndpointBuilder epb = muleContext.getRegistry().lookupEndpointBuilder("test.ep2");
        InboundEndpoint ep = epb.buildInboundEndpoint();
        Assert.assertNotNull((Object)ep.getFilter());
        Assert.assertTrue((boolean)(ep.getFilter() instanceof JaxenFilter));
        JaxenFilter filter = (JaxenFilter)ep.getFilter();
        Assert.assertEquals((Object)"/car:foo/car:bar", (Object)filter.getPattern());
        Assert.assertEquals((long)6L, (long)filter.getNamespaces().size());
        Assert.assertEquals((Object)"http://car.com", filter.getNamespaces().get("car"));
    }

    @Test
    public void testJXPathExtractor() throws Exception {
        JXPathExtractor transformer = (JXPathExtractor)this.lookupTransformer("jxpath-extractor");
        transformer.initialise();
        Assert.assertNotNull((Object)transformer.getNamespaces());
        Assert.assertEquals((long)6L, (long)transformer.getNamespaces().size());
        Assert.assertNotNull(transformer.getNamespaces().get("foo"));
        Assert.assertNotNull(transformer.getNamespaces().get("bar"));
    }

    @Test
    public void testJaxbConfig() throws Exception {
        JAXBMarshallerTransformer t = (JAXBMarshallerTransformer)this.lookupTransformer("ObjectToXml");
        Assert.assertNotNull((Object)t.getJaxbContext());
        JAXBUnmarshallerTransformer t2 = (JAXBUnmarshallerTransformer)this.lookupTransformer("XmlToObject");
        Assert.assertEquals(Person.class, (Object)t2.getReturnDataType().getType());
        Assert.assertNotNull((Object)t2.getJaxbContext());
    }

    @Test
    public void testSchemaValidationFilterWithCustomResourceResolver() {
        SchemaValidationFilter filter = (SchemaValidationFilter)this.lookupFilter("SchemaValidationWithResourceResolver");
        Assert.assertEquals((Object)"schema1.xsd", (Object)filter.getSchemaLocations());
        Assert.assertTrue((boolean)(filter.getResourceResolver() instanceof MockResourceResolver));
        Assert.assertTrue((boolean)(filter.getErrorHandler() instanceof MockErrorHandler));
        Assert.assertFalse((boolean)filter.isReturnResult());
    }

    private Transformer lookupTransformer(String name) {
        Transformer transformer = muleContext.getRegistry().lookupTransformer(name);
        Assert.assertNotNull((Object)transformer);
        return transformer;
    }

    private Filter lookupFilter(String name) {
        Filter filter = (Filter)muleContext.getRegistry().lookupObject(name);
        Assert.assertNotNull((Object)filter);
        return filter;
    }

    private static class MockErrorHandler
    implements ErrorHandler {
        private MockErrorHandler() {
        }

        @Override
        public void error(SAXParseException exception) throws SAXException {
        }

        @Override
        public void fatalError(SAXParseException exception) throws SAXException {
        }

        @Override
        public void warning(SAXParseException exception) throws SAXException {
        }
    }

    private static class MockResourceResolver
    implements LSResourceResolver {
        private MockResourceResolver() {
        }

        @Override
        public LSInput resolveResource(String type, String namespaceURI, String publicId, String systemId, String baseURI) {
            return null;
        }
    }
}

