/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.annotationx.reply;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.processor.MessageProcessor;
import org.mule.api.routing.RoutingException;
import org.mule.api.service.Service;
import org.mule.routing.EventGroup;
import org.mule.routing.correlation.EventCorrelatorCallback;

public class SingleResponseWithCallbackCorrelator
implements EventCorrelatorCallback {
    protected final transient Log logger = LogFactory.getLog(SingleResponseWithCallbackCorrelator.class);
    protected String callback;

    public SingleResponseWithCallbackCorrelator(String callbackMethod) {
        this.callback = callbackMethod;
    }

    public boolean shouldAggregateEvents(EventGroup events) {
        if (events.expectedSize() > 1) {
            this.logger.warn((Object)"CorrelationGroup's expected size is not 1. The SingleResponseAggregator will only handle single replyTo events; if there will be multiple events for a single request,  use the 'ResponseCorrelationAggregator'");
        }
        return events.size() != 0;
    }

    public MuleEvent aggregateEvents(EventGroup events) throws RoutingException {
        MuleEvent event = (MuleEvent)events.iterator().next();
        if (!(event.getFlowConstruct() instanceof Service)) {
            throw new UnsupportedOperationException("CollectionResponseWithCallbackCorrelator is only supported with Service");
        }
        if (this.callback != null) {
            event.getMessage().setInvocationProperty("method", (Object)this.callback);
            try {
                return ((Service)event.getFlowConstruct()).getComponent().process(event);
            }
            catch (MuleException e) {
                throw new RoutingException(event, (MessageProcessor)event.getEndpoint(), (Throwable)e);
            }
        }
        return event;
    }

    public EventGroup createEventGroup(MuleEvent event, Object id) {
        return new EventGroup(id);
    }
}

