/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.annotationx.parsers;

import java.lang.annotation.Annotation;
import java.lang.reflect.Member;
import org.mule.MessageExchangePattern;
import org.mule.api.MessageProcessorAnnotationParser;
import org.mule.api.MuleException;
import org.mule.api.annotations.meta.Channel;
import org.mule.api.annotations.meta.ChannelType;
import org.mule.api.processor.MessageProcessor;
import org.mule.config.endpoint.AbstractEndpointAnnotationParser;
import org.mule.config.endpoint.AnnotatedEndpointData;
import org.mule.module.annotationx.api.Reply;
import org.mule.module.annotationx.reply.SingleResponseWithCallbackRouter;
import org.mule.util.StringUtils;

public class ReplyAnnotationParser
extends AbstractEndpointAnnotationParser
implements MessageProcessorAnnotationParser {
    protected AnnotatedEndpointData createEndpointData(Annotation annotation) throws MuleException {
        Reply reply = (Reply)annotation;
        AnnotatedEndpointData epd = new AnnotatedEndpointData(MessageExchangePattern.ONE_WAY, ChannelType.Reply, (Annotation)reply);
        epd.setConnectorName(reply.connector());
        epd.setAddress(reply.uri());
        epd.setFilter(reply.filter());
        return epd;
    }

    protected String getIdentifier() {
        return Reply.class.getAnnotation(Channel.class).identifer();
    }

    public MessageProcessor parseMessageProcessor(Annotation annotation) throws MuleException {
        Reply reply = (Reply)annotation;
        SingleResponseWithCallbackRouter router = new SingleResponseWithCallbackRouter();
        if (StringUtils.isNotBlank((String)reply.callback())) {
            router.setCallbackMethod(reply.callback());
        }
        router.setTimeout(reply.replyTimeout());
        router.setFailOnTimeout(reply.failOnTimeout());
        return null;
    }

    public boolean supports(Annotation annotation, Class clazz, Member member) {
        if (clazz.isInterface()) {
            return false;
        }
        return super.supports(annotation, clazz, member);
    }
}

