/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.annotationx.jsr330;

import java.lang.reflect.Field;
import javax.inject.Named;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.api.MuleContext;
import org.mule.api.context.MuleContextAware;
import org.mule.api.registry.InjectProcessor;
import org.mule.util.StringUtils;

public class NamedAnnotationProcessor
implements InjectProcessor,
MuleContextAware {
    protected final transient Log logger = LogFactory.getLog(NamedAnnotationProcessor.class);
    private MuleContext context;

    public NamedAnnotationProcessor() {
    }

    public NamedAnnotationProcessor(MuleContext context) {
        this.context = context;
    }

    public void setMuleContext(MuleContext context) {
        this.context = context;
    }

    public Object process(Object object) {
        Field[] fields;
        try {
            fields = object.getClass().getDeclaredFields();
        }
        catch (NoClassDefFoundError e) {
            if (this.logger.isDebugEnabled()) {
                this.logger.warn((Object)e.toString());
            }
            return object;
        }
        for (int i = 0; i < fields.length; ++i) {
            Field field = fields[i];
            if (!field.isAnnotationPresent(Named.class)) continue;
            Named named = field.getAnnotation(Named.class);
            try {
                Object value;
                field.setAccessible(true);
                if (StringUtils.isNotBlank((String)named.value())) {
                    value = this.context.getRegistry().lookupObject(named.value());
                    if (value == null) {
                        throw new RuntimeException("Required object not found in registry with key: " + named.value());
                    }
                } else {
                    value = this.context.getRegistry().lookupObject(field.getType());
                    if (value == null) {
                        throw new RuntimeException("Required object not found in registry of Type: " + field.getType());
                    }
                }
                field.set(object, value);
                continue;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return object;
    }
}

