/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.annotationx.config;

import java.util.Arrays;
import java.util.Map;
import org.mule.MessageExchangePattern;
import org.mule.api.MuleContext;
import org.mule.api.MuleException;
import org.mule.api.NamedObject;
import org.mule.api.endpoint.EndpointBuilder;
import org.mule.api.endpoint.ImmutableEndpoint;
import org.mule.api.endpoint.InboundEndpoint;
import org.mule.api.endpoint.OutboundEndpoint;
import org.mule.api.processor.MessageProcessor;
import org.mule.api.registry.Registry;
import org.mule.api.routing.filter.Filter;
import org.mule.api.security.EndpointSecurityFilter;
import org.mule.api.transformer.Transformer;
import org.mule.api.transport.Connector;
import org.mule.processor.SecurityFilterMessageProcessor;
import org.mule.registry.RegistryMap;
import org.mule.routing.MessageFilter;
import org.mule.routing.filters.logic.AndFilter;
import org.mule.routing.filters.logic.OrFilter;
import org.mule.util.TemplateParser;

public class ChannelConfigBuilder
implements NamedObject {
    protected TemplateParser parser = TemplateParser.createAntStyleParser();
    private EndpointBuilder endpointBuilder;
    private String channelId;
    private MuleContext muleContext;

    public ChannelConfigBuilder(String channelId, String uri, MuleContext muleContext) throws MuleException {
        this.channelId = channelId;
        this.muleContext = muleContext;
        this.endpointBuilder = muleContext.getRegistry().lookupEndpointFactory().getEndpointBuilder(this.getPropertyValue(uri, muleContext));
        this.endpointBuilder.setMuleContext(muleContext);
        this.endpointBuilder.setName(channelId);
    }

    public ChannelConfigBuilder setConnector(Connector connector) {
        try {
            connector.setName(this.channelId + ".connector");
            this.muleContext.getRegistry().registerConnector(connector);
        }
        catch (MuleException e) {
            throw new RuntimeException(e);
        }
        this.endpointBuilder.setConnector(connector);
        return this;
    }

    public ChannelConfigBuilder addTransformer(Transformer transformer) {
        this.endpointBuilder.addTransformer(transformer);
        return this;
    }

    public ChannelConfigBuilder addTransformers(Transformer ... transformer) {
        this.endpointBuilder.setTransformers(Arrays.asList(transformer));
        return this;
    }

    public ChannelConfigBuilder addResponseTransformer(Transformer transformer) {
        this.endpointBuilder.addResponseTransformer(transformer);
        return this;
    }

    public ChannelConfigBuilder addResponseTransformers(Transformer ... transformer) {
        this.endpointBuilder.setResponseTransformers(Arrays.asList(transformer));
        return this;
    }

    public ChannelConfigBuilder andFilters(Filter ... filters) {
        this.endpointBuilder.addMessageProcessor((MessageProcessor)new MessageFilter((Filter)new AndFilter(filters)));
        return this;
    }

    public ChannelConfigBuilder orFilter(Filter ... filters) {
        this.endpointBuilder.addMessageProcessor((MessageProcessor)new MessageFilter((Filter)new OrFilter(filters)));
        return this;
    }

    public ChannelConfigBuilder filter(Filter filter) {
        this.endpointBuilder.addMessageProcessor((MessageProcessor)new MessageFilter(filter));
        return this;
    }

    public ChannelConfigBuilder setSecurityFilter(EndpointSecurityFilter filter) {
        this.endpointBuilder.addMessageProcessor((MessageProcessor)new SecurityFilterMessageProcessor(filter));
        return this;
    }

    public ChannelConfigBuilder setEncoding(String encoding) {
        this.endpointBuilder.setEncoding(encoding);
        return this;
    }

    public ChannelConfigBuilder addProperty(String key, Object value) {
        this.endpointBuilder.setProperty((Object)key, value);
        return this;
    }

    public InboundEndpoint buildReceiveChannel() throws MuleException {
        this.endpointBuilder.setExchangePattern(MessageExchangePattern.ONE_WAY);
        InboundEndpoint ep = this.endpointBuilder.buildInboundEndpoint();
        this.muleContext.getRegistry().registerEndpoint((ImmutableEndpoint)ep);
        return ep;
    }

    public InboundEndpoint buildReceiveAndReplyChannel() throws MuleException {
        this.endpointBuilder.setExchangePattern(MessageExchangePattern.REQUEST_RESPONSE);
        InboundEndpoint ep = this.endpointBuilder.buildInboundEndpoint();
        this.muleContext.getRegistry().registerEndpoint((ImmutableEndpoint)ep);
        return ep;
    }

    public OutboundEndpoint buildSendChannel() throws MuleException {
        this.endpointBuilder.setExchangePattern(MessageExchangePattern.ONE_WAY);
        OutboundEndpoint ep = this.endpointBuilder.buildOutboundEndpoint();
        this.muleContext.getRegistry().registerEndpoint((ImmutableEndpoint)ep);
        return ep;
    }

    protected String getPropertyValue(String key, MuleContext context) {
        return this.parser.parse((Map)new RegistryMap((Registry)context.getRegistry()), key);
    }

    public void setName(String name) {
        throw new UnsupportedOperationException("setName");
    }

    public String getName() {
        return this.channelId + ".builder";
    }
}

