/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.annotationx.config;

import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.mule.api.AnnotationException;
import org.mule.api.EndpointAnnotationParser;
import org.mule.api.MessageProcessorAnnotationParser;
import org.mule.api.MuleContext;
import org.mule.api.MuleException;
import org.mule.api.annotations.meta.Channel;
import org.mule.api.annotations.meta.ChannelType;
import org.mule.api.annotations.meta.Router;
import org.mule.api.annotations.meta.RouterType;
import org.mule.api.component.Component;
import org.mule.api.context.MuleContextAware;
import org.mule.api.endpoint.InboundEndpoint;
import org.mule.api.endpoint.OutboundEndpoint;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.model.Model;
import org.mule.api.object.ObjectFactory;
import org.mule.api.processor.MessageProcessor;
import org.mule.api.registry.Registry;
import org.mule.api.routing.MatchableMessageProcessor;
import org.mule.api.routing.OutboundRouter;
import org.mule.api.routing.OutboundRouterCollection;
import org.mule.api.service.Service;
import org.mule.api.source.MessageSource;
import org.mule.component.DefaultJavaComponent;
import org.mule.component.PooledJavaComponent;
import org.mule.config.AnnotationsParserFactory;
import org.mule.config.endpoint.AnnotatedEndpointHelper;
import org.mule.config.i18n.AnnotationsMessages;
import org.mule.model.seda.SedaService;
import org.mule.module.annotationx.api.Reply;
import org.mule.module.annotationx.config.ObjectScope;
import org.mule.object.PrototypeObjectFactory;
import org.mule.object.SingletonObjectFactory;
import org.mule.registry.RegistryMap;
import org.mule.routing.outbound.OutboundPassThroughRouter;
import org.mule.service.ServiceCompositeMessageSource;
import org.mule.util.BeanUtils;
import org.mule.util.TemplateParser;
import org.mule.util.annotation.AnnotationMetaData;
import org.mule.util.annotation.AnnotationUtils;

public class AnnotatedServiceBuilder {
    protected MuleContext context;
    private Model model;
    private final TemplateParser parser = TemplateParser.createAntStyleParser();
    protected RegistryMap regProps;
    protected AnnotatedEndpointHelper helper;
    protected AnnotationsParserFactory parserFactory;

    public Model getModel() {
        return this.model;
    }

    public void setModel(Model model) {
        this.model = model;
    }

    public AnnotatedServiceBuilder(MuleContext context) throws MuleException {
        this.context = context;
        this.regProps = new RegistryMap((Registry)context.getRegistry());
        this.helper = new AnnotatedEndpointHelper(context);
        this.parserFactory = (AnnotationsParserFactory)context.getRegistry().lookupObject(AnnotationsParserFactory.class);
        assert (this.parserFactory != null);
    }

    protected ObjectFactory createObjectFactory(Object object) {
        org.mule.module.annotationx.api.Service serv = object.getClass().getAnnotation(org.mule.module.annotationx.api.Service.class);
        if (serv.scope().equals((Object)ObjectScope.SINGLETON)) {
            return new SingletonObjectFactory(object);
        }
        Map props = BeanUtils.describe((Object)object);
        return new PrototypeObjectFactory(object.getClass(), props);
    }

    public Service createService(Object object) throws MuleException {
        Class<?> componentFactoryClass = object.getClass();
        Service serviceDescriptor = this.create(this.createObjectFactory(object));
        this.processInbound(componentFactoryClass, serviceDescriptor);
        this.processOutbound(componentFactoryClass, serviceDescriptor);
        this.processReply(componentFactoryClass, serviceDescriptor);
        return serviceDescriptor;
    }

    protected Service create(ObjectFactory componentFactory) throws InitialisationException {
        SedaService serviceDescriptor = new SedaService(this.context);
        serviceDescriptor.setModel(this.model);
        org.mule.module.annotationx.api.Service service = componentFactory.getObjectClass().getAnnotation(org.mule.module.annotationx.api.Service.class);
        serviceDescriptor.setName(this.getValue(service.name()));
        componentFactory.initialise();
        if (service.scope().equals((Object)ObjectScope.POOLED)) {
            serviceDescriptor.setComponent((Component)new PooledJavaComponent(componentFactory));
        } else {
            serviceDescriptor.setComponent((Component)new DefaultJavaComponent(componentFactory));
        }
        return serviceDescriptor;
    }

    protected String getValue(String key) {
        return this.parser.parse((Map)this.regProps, key);
    }

    protected void processInbound(Class componentFactoryClass, Service service) throws MuleException {
        List annotations = AnnotationUtils.getClassAndMethodAnnotations((Class)componentFactoryClass);
        for (AnnotationMetaData annotation : annotations) {
            InboundEndpoint inboundEndpoint = this.tryInboundEndpointAnnotation(annotation, ChannelType.Inbound);
            if (inboundEndpoint == null) continue;
            if (annotation.getType() == ElementType.METHOD) {
                inboundEndpoint.getProperties().put("method", annotation.getElementName());
            }
            ((ServiceCompositeMessageSource)service.getMessageSource()).addSource((MessageSource)inboundEndpoint);
        }
        this.processInboundRouters(componentFactoryClass, service);
    }

    protected void processInboundRouters(Class componentFactoryClass, Service service) throws MuleException {
        for (int i = 0; i < componentFactoryClass.getAnnotations().length; ++i) {
            Annotation annotation = componentFactoryClass.getAnnotations()[i];
            Router routerAnnotation = annotation.annotationType().getAnnotation(Router.class);
            if (routerAnnotation == null || routerAnnotation.type() != RouterType.Inbound) continue;
            MessageProcessorAnnotationParser parser = this.parserFactory.getRouterParser(annotation, componentFactoryClass, null);
            if (parser != null) {
                ((ServiceCompositeMessageSource)service.getMessageSource()).addMessageProcessor(parser.parseMessageProcessor(annotation));
                continue;
            }
            throw new IllegalStateException("Cannot find parser for router annotation: " + ((Object)annotation).toString());
        }
    }

    protected void processReplyRouters(Class componentFactoryClass, Service service) throws MuleException {
        List annotations = AnnotationUtils.getClassAndMethodAnnotations((Class)componentFactoryClass);
        for (AnnotationMetaData metaData : annotations) {
            Router routerAnnotation = metaData.getAnnotation().annotationType().getAnnotation(Router.class);
            if (routerAnnotation == null || routerAnnotation.type() != RouterType.ReplyTo) continue;
            MessageProcessorAnnotationParser parser = this.parserFactory.getRouterParser(metaData.getAnnotation(), metaData.getClazz(), metaData.getMember());
            if (parser != null) {
                MessageProcessor router = parser.parseMessageProcessor(metaData.getAnnotation());
                if (!(router instanceof MuleContextAware)) break;
                ((MuleContextAware)router).setMuleContext(this.context);
                break;
            }
            throw new IllegalStateException("Cannot find parser for router annotation: " + ((Object)metaData.getAnnotation()).toString());
        }
    }

    protected OutboundRouter processOutboundRouter(Class componentFactoryClass) throws MuleException {
        Collection routerParsers = this.context.getRegistry().lookupObjects(MessageProcessorAnnotationParser.class);
        OutboundPassThroughRouter router = null;
        List annotations = AnnotationUtils.getClassAndMethodAnnotations((Class)componentFactoryClass);
        for (AnnotationMetaData metaData : annotations) {
            Router routerAnnotation = metaData.getAnnotation().annotationType().getAnnotation(Router.class);
            if (routerAnnotation == null || routerAnnotation.type() != RouterType.Outbound) continue;
            if (router != null) {
                throw new IllegalStateException("You can only configure one outbound router on a service");
            }
            MessageProcessorAnnotationParser parser = this.parserFactory.getRouterParser(metaData.getAnnotation(), metaData.getClazz(), metaData.getMember());
            if (parser != null) {
                router = (OutboundRouter)parser.parseMessageProcessor(metaData.getAnnotation());
                continue;
            }
            throw new IllegalStateException("Cannot find parser for router annotation: " + ((Object)metaData.getAnnotation()).toString());
        }
        if (router == null) {
            router = new OutboundPassThroughRouter();
        }
        if (router instanceof MuleContextAware) {
            router.setMuleContext(this.context);
        }
        router.initialise();
        return router;
    }

    protected void processOutbound(Class componentFactoryClass, Service service) throws MuleException {
        OutboundRouter router = this.processOutboundRouter(componentFactoryClass);
        Reply replyEp = componentFactoryClass.getAnnotation(Reply.class);
        if (replyEp != null) {
            router.setReplyTo(replyEp.uri());
        }
        List annotations = AnnotationUtils.getClassAndMethodAnnotations((Class)componentFactoryClass);
        for (AnnotationMetaData annotation : annotations) {
            OutboundEndpoint outboundEndpoint = this.tryOutboundEndpointAnnotation(annotation, ChannelType.Outbound);
            if (outboundEndpoint == null) continue;
            router.addRoute((MessageProcessor)outboundEndpoint);
        }
        if (router instanceof MuleContextAware) {
            router.setMuleContext(this.context);
        }
        router.initialise();
        ((OutboundRouterCollection)service.getOutboundMessageProcessor()).addRoute((MatchableMessageProcessor)router);
    }

    protected InboundEndpoint tryInboundEndpointAnnotation(AnnotationMetaData metaData, ChannelType channelType) throws MuleException {
        Channel channelAnno = metaData.getAnnotation().annotationType().getAnnotation(Channel.class);
        if (channelAnno != null && channelAnno.type() == channelType) {
            EndpointAnnotationParser parser = this.parserFactory.getEndpointParser(metaData.getAnnotation(), metaData.getClazz(), metaData.getMember());
            if (parser == null) {
                throw new AnnotationException(AnnotationsMessages.createStaticMessage((String)("No parser found for annotation: " + metaData)));
            }
            return parser.parseInboundEndpoint(metaData.getAnnotation(), Collections.EMPTY_MAP);
        }
        return null;
    }

    protected OutboundEndpoint tryOutboundEndpointAnnotation(AnnotationMetaData metaData, ChannelType channelType) throws MuleException {
        Channel channelAnno = metaData.getAnnotation().annotationType().getAnnotation(Channel.class);
        if (channelAnno != null && channelAnno.type() == channelType) {
            EndpointAnnotationParser parser = this.parserFactory.getEndpointParser(metaData.getAnnotation(), metaData.getClazz(), metaData.getMember());
            if (parser == null) {
                throw new AnnotationException(AnnotationsMessages.createStaticMessage((String)("No parser found for annotation: " + metaData)));
            }
            return parser.parseOutboundEndpoint(metaData.getAnnotation(), Collections.EMPTY_MAP);
        }
        return null;
    }

    protected void processReply(Class componentFactoryClass, Service service) throws MuleException {
        for (int i = 0; i < componentFactoryClass.getAnnotations().length; ++i) {
            Annotation annotation = componentFactoryClass.getAnnotations()[i];
            InboundEndpoint inboundEndpoint = this.tryInboundEndpointAnnotation(new AnnotationMetaData(componentFactoryClass, null, ElementType.TYPE, annotation), ChannelType.Reply);
            if (inboundEndpoint == null) continue;
            service.getAsyncReplyMessageSource().addSource((MessageSource)inboundEndpoint);
        }
        this.processReplyRouters(componentFactoryClass, service);
    }
}

