/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.ws.security;

import java.util.ArrayList;
import java.util.Map;
import org.apache.ws.security.WSPasswordCallback;
import org.mule.runtime.core.util.StringUtils;
import org.mule.runtime.module.ws.security.AbstractSecurityStrategy;
import org.mule.runtime.module.ws.security.PasswordType;
import org.mule.runtime.module.ws.security.SecurityStrategy;
import org.mule.runtime.module.ws.security.WSPasswordCallbackHandler;

public class WssUsernameTokenSecurityStrategy
extends AbstractSecurityStrategy
implements SecurityStrategy {
    private String username;
    private String password;
    private PasswordType passwordType;
    private boolean addNonce;
    private boolean addCreated;

    @Override
    public void apply(Map<String, Object> outConfigProperties, Map<String, Object> inConfigProperties) {
        this.appendAction(outConfigProperties, "UsernameToken");
        outConfigProperties.put("user", this.username);
        if (this.passwordType == PasswordType.TEXT) {
            outConfigProperties.put("passwordType", "PasswordText");
        } else if (this.passwordType == PasswordType.DIGEST) {
            outConfigProperties.put("passwordType", "PasswordDigest");
        }
        ArrayList<String> additionalElements = new ArrayList<String>(2);
        if (this.addNonce) {
            additionalElements.add("Nonce");
        }
        if (this.addCreated) {
            additionalElements.add("Created");
        }
        if (!additionalElements.isEmpty()) {
            outConfigProperties.put("addUTElements", StringUtils.join(additionalElements, (String)" "));
        }
        this.addPasswordCallbackHandler(outConfigProperties, new WSPasswordCallbackHandler(2){

            @Override
            public void handle(WSPasswordCallback passwordCallback) {
                if (passwordCallback.getIdentifier().equals(WssUsernameTokenSecurityStrategy.this.username)) {
                    passwordCallback.setPassword(WssUsernameTokenSecurityStrategy.this.password);
                }
            }
        });
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public PasswordType getPasswordType() {
        return this.passwordType;
    }

    public void setPasswordType(PasswordType passwordType) {
        this.passwordType = passwordType;
    }

    public boolean isAddNonce() {
        return this.addNonce;
    }

    public void setAddNonce(boolean addNonce) {
        this.addNonce = addNonce;
    }

    public boolean isAddCreated() {
        return this.addCreated;
    }

    public void setAddCreated(boolean addCreated) {
        this.addCreated = addCreated;
    }
}

