/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.ws.security;

import java.util.Map;
import java.util.Properties;
import org.apache.ws.security.WSPasswordCallback;
import org.mule.runtime.api.tls.TlsContextFactory;
import org.mule.runtime.api.tls.TlsContextKeyStoreConfiguration;
import org.mule.runtime.module.ws.security.AbstractSecurityStrategy;
import org.mule.runtime.module.ws.security.WSCryptoUtils;
import org.mule.runtime.module.ws.security.WSPasswordCallbackHandler;

public class WssSignSecurityStrategy
extends AbstractSecurityStrategy {
    private static final String WS_SIGN_PROPERTIES_KEY = "signProperties";
    private TlsContextFactory tlsContextFactory;

    @Override
    public void apply(Map<String, Object> outConfigProperties, Map<String, Object> inConfigProperties) {
        final TlsContextKeyStoreConfiguration keyStoreConfig = this.tlsContextFactory.getKeyStoreConfiguration();
        this.appendAction(outConfigProperties, "Signature");
        Properties signProperties = WSCryptoUtils.createKeyStoreProperties(keyStoreConfig);
        outConfigProperties.put("signaturePropRefId", WS_SIGN_PROPERTIES_KEY);
        outConfigProperties.put(WS_SIGN_PROPERTIES_KEY, signProperties);
        outConfigProperties.put("signatureUser", keyStoreConfig.getAlias());
        this.addPasswordCallbackHandler(outConfigProperties, new WSPasswordCallbackHandler(3){

            @Override
            public void handle(WSPasswordCallback passwordCallback) {
                passwordCallback.setPassword(keyStoreConfig.getKeyPassword());
            }
        });
    }

    public TlsContextFactory getTlsContext() {
        return this.tlsContextFactory;
    }

    public void setTlsContext(TlsContextFactory tlsContextFactory) {
        this.tlsContextFactory = tlsContextFactory;
    }
}

