/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.ws.security;

import java.util.Map;
import java.util.Properties;
import org.mule.runtime.api.tls.TlsContextFactory;
import org.mule.runtime.module.ws.security.AbstractSecurityStrategy;
import org.mule.runtime.module.ws.security.WSCryptoUtils;

public class WssEncryptSecurityStrategy
extends AbstractSecurityStrategy {
    private static final String WS_ENCRYPT_PROPERTIES_KEY = "encryptProperties";
    private TlsContextFactory tlsContextFactory;
    private String alias;

    @Override
    public void apply(Map<String, Object> outConfigProperties, Map<String, Object> inConfigProperties) {
        this.appendAction(outConfigProperties, "Encrypt");
        Properties encryptionProperties = this.tlsContextFactory == null ? WSCryptoUtils.createDefaultTrustStoreProperties() : WSCryptoUtils.createTrustStoreProperties(this.tlsContextFactory.getTrustStoreConfiguration());
        outConfigProperties.put("encryptionPropRefId", WS_ENCRYPT_PROPERTIES_KEY);
        outConfigProperties.put(WS_ENCRYPT_PROPERTIES_KEY, encryptionProperties);
        outConfigProperties.put("encryptionUser", this.alias);
    }

    public TlsContextFactory getTlsContext() {
        return this.tlsContextFactory;
    }

    public void setTlsContext(TlsContextFactory tlsContextFactory) {
        this.tlsContextFactory = tlsContextFactory;
    }

    public String getAlias() {
        return this.alias;
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }
}

