/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.ws.security;

import java.util.Map;
import java.util.Properties;
import org.apache.ws.security.WSPasswordCallback;
import org.mule.runtime.api.tls.TlsContextFactory;
import org.mule.runtime.api.tls.TlsContextKeyStoreConfiguration;
import org.mule.runtime.module.ws.security.AbstractSecurityStrategy;
import org.mule.runtime.module.ws.security.WSCryptoUtils;
import org.mule.runtime.module.ws.security.WSPasswordCallbackHandler;

public class WssDecryptSecurityStrategy
extends AbstractSecurityStrategy {
    private static final String WS_DECRYPT_PROPERTIES_KEY = "decryptProperties";
    private TlsContextFactory tlsContextFactory;

    @Override
    public void apply(Map<String, Object> outConfigProperties, Map<String, Object> inConfigProperties) {
        final TlsContextKeyStoreConfiguration keyStoreConfig = this.tlsContextFactory.getKeyStoreConfiguration();
        this.appendAction(inConfigProperties, "Encrypt");
        Properties decryptionProperties = WSCryptoUtils.createKeyStoreProperties(keyStoreConfig);
        inConfigProperties.put("decryptionPropRefId", WS_DECRYPT_PROPERTIES_KEY);
        inConfigProperties.put(WS_DECRYPT_PROPERTIES_KEY, decryptionProperties);
        this.addPasswordCallbackHandler(inConfigProperties, new WSPasswordCallbackHandler(1){

            @Override
            public void handle(WSPasswordCallback passwordCallback) {
                passwordCallback.setPassword(keyStoreConfig.getKeyPassword());
            }
        });
    }

    public TlsContextFactory getTlsContext() {
        return this.tlsContextFactory;
    }

    public void setTlsContext(TlsContextFactory tlsContextFactory) {
        this.tlsContextFactory = tlsContextFactory;
    }
}

