/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.ws.consumer;

import java.io.File;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.wsdl.Binding;
import javax.wsdl.BindingOperation;
import javax.wsdl.Definition;
import javax.wsdl.Import;
import javax.wsdl.Types;
import javax.wsdl.extensions.schema.Schema;
import javax.wsdl.extensions.schema.SchemaReference;
import javax.wsdl.extensions.soap.SOAPBinding;
import javax.wsdl.extensions.soap.SOAPBody;
import javax.wsdl.extensions.soap12.SOAP12Binding;
import javax.wsdl.extensions.soap12.SOAP12Body;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.mule.runtime.core.util.StringUtils;
import org.mule.runtime.module.http.api.HttpConstants;
import org.mule.runtime.module.ws.consumer.SoapVersion;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class WSDLUtils {
    private static final String XML_NS_PREFIX = "xmlns:";
    private static final String XML_IMPORT_ELEMENT = "import";
    private static final String XML_INCLUDE_ELEMENT = "include";
    private static final String XML_SCHEMA_LOCATION_ATTRIBUTE = "schemaLocation";

    public static List<String> getSchemas(Definition wsdlDefinition) throws TransformerException {
        Map wsdlNamespaces = wsdlDefinition.getNamespaces();
        ArrayList<String> schemas = new ArrayList<String>();
        ArrayList<Types> typesList = new ArrayList<Types>();
        if (wsdlDefinition.getTypes() != null) {
            typesList.add(wsdlDefinition.getTypes());
        }
        for (Types types : typesList) {
            for (Object o : types.getExtensibilityElements()) {
                if (!(o instanceof Schema)) continue;
                Schema schema = (Schema)o;
                for (Map.Entry entry : wsdlNamespaces.entrySet()) {
                    boolean isDefault = StringUtils.isEmpty((String)((String)entry.getKey()));
                    boolean containsNamespace = schema.getElement().hasAttribute(XML_NS_PREFIX + (String)entry.getKey());
                    if (isDefault || containsNamespace) continue;
                    schema.getElement().setAttribute(XML_NS_PREFIX + (String)entry.getKey(), (String)entry.getValue());
                }
                WSDLUtils.fixSchemaLocations(schema);
                schemas.add(WSDLUtils.schemaToString(schema));
            }
        }
        for (Object wsdlImportList : wsdlDefinition.getImports().values()) {
            for (Import wsdlImport : (List)wsdlImportList) {
                schemas.addAll(WSDLUtils.getSchemas(wsdlImport.getDefinition()));
            }
        }
        return schemas;
    }

    private static void fixSchemaLocations(Schema schema) {
        String basePath = WSDLUtils.getBasePath(schema.getDocumentBaseURI());
        Collection schemaImportsCollection = schema.getImports().values();
        List schemaIncludesCollection = schema.getIncludes();
        if (!schemaImportsCollection.isEmpty() || !schemaIncludesCollection.isEmpty()) {
            for (List schemaReferences : schemaImportsCollection) {
                WSDLUtils.fixSchemaReferencesLocations(basePath, schemaReferences);
            }
            WSDLUtils.fixSchemaReferencesLocations(basePath, schemaIncludesCollection);
            NodeList children = schema.getElement().getChildNodes();
            for (int i = 0; i < children.getLength(); ++i) {
                String schemaLocation;
                NamedNodeMap attributes;
                Node namedItem;
                Node item = children.item(i);
                if (!XML_IMPORT_ELEMENT.equals(item.getLocalName()) && !XML_INCLUDE_ELEMENT.equals(item.getLocalName()) || (namedItem = (attributes = item.getAttributes()).getNamedItem(XML_SCHEMA_LOCATION_ATTRIBUTE)) == null || (schemaLocation = namedItem.getNodeValue()).startsWith(basePath) || schemaLocation.startsWith(HttpConstants.Protocols.HTTP.getScheme())) continue;
                namedItem.setNodeValue(basePath + schemaLocation);
            }
        }
    }

    private static void fixSchemaReferencesLocations(String basePath, Collection<SchemaReference> schemaReferences) {
        for (SchemaReference schemaReference : schemaReferences) {
            String schemaLocationURI = schemaReference.getSchemaLocationURI();
            if (schemaLocationURI == null || schemaLocationURI.startsWith(basePath) || schemaLocationURI.startsWith(HttpConstants.Protocols.HTTP.getScheme())) continue;
            schemaReference.setSchemaLocationURI(basePath + schemaLocationURI);
        }
    }

    private static String getBasePath(String documentURI) {
        File document = new File(documentURI);
        if (document.isDirectory()) {
            return documentURI;
        }
        String fileName = document.getName();
        int fileNameIndex = documentURI.lastIndexOf(fileName);
        if (fileNameIndex == -1) {
            return documentURI;
        }
        return documentURI.substring(0, fileNameIndex);
    }

    public static String schemaToString(Schema schema) throws TransformerException {
        StringWriter writer = new StringWriter();
        Transformer transformer = TransformerFactory.newInstance().newTransformer();
        transformer.transform(new DOMSource(schema.getElement()), new StreamResult(writer));
        return writer.toString();
    }

    public static List<String> getSoapBodyParts(BindingOperation bindingOperation) {
        List extensions = bindingOperation.getBindingInput().getExtensibilityElements();
        List result = null;
        boolean found = false;
        for (Object extension : extensions) {
            if (extension instanceof SOAPBody) {
                result = ((SOAPBody)extension).getParts();
                found = true;
                break;
            }
            if (!(extension instanceof SOAP12Body)) continue;
            result = ((SOAP12Body)extension).getParts();
            found = true;
            break;
        }
        if (found && result == null) {
            result = Collections.emptyList();
        }
        return result;
    }

    public static SoapVersion getSoapVersion(Binding binding) {
        List extensions = binding.getExtensibilityElements();
        for (Object extension : extensions) {
            if (extension instanceof SOAPBinding) {
                return SoapVersion.SOAP_11;
            }
            if (!(extension instanceof SOAP12Binding)) continue;
            return SoapVersion.SOAP_12;
        }
        return null;
    }
}

