/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.ws.consumer;

import org.mule.runtime.core.MessageExchangePattern;
import org.mule.runtime.core.api.Event;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.MuleException;
import org.mule.runtime.core.api.client.OperationOptions;
import org.mule.runtime.core.api.config.ConfigurationException;
import org.mule.runtime.core.api.connector.ConnectorOperationLocator;
import org.mule.runtime.core.api.construct.FlowConstruct;
import org.mule.runtime.core.api.construct.FlowConstructAware;
import org.mule.runtime.core.api.context.MuleContextAware;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.api.transport.LegacyConnector;
import org.mule.runtime.core.config.i18n.CoreMessages;
import org.mule.runtime.core.util.Preconditions;
import org.mule.runtime.core.util.StringUtils;
import org.mule.runtime.module.http.api.HttpConstants;
import org.mule.runtime.module.http.api.client.HttpRequestOptions;
import org.mule.runtime.module.http.api.client.HttpRequestOptionsBuilder;
import org.mule.runtime.module.http.api.requester.HttpRequesterConfig;
import org.mule.runtime.module.ws.security.WSSecurity;

public class WSConsumerConfig
implements MuleContextAware {
    private MuleContext muleContext;
    private String name;
    private String wsdlLocation;
    private String service;
    private String port;
    private String serviceAddress;
    private LegacyConnector connector;
    private HttpRequesterConfig connectorConfig;
    private WSSecurity security;

    public void setMuleContext(MuleContext muleContext) {
        this.muleContext = muleContext;
    }

    public Processor createOutboundMessageProcessor(FlowConstruct flowConstruct) throws MuleException {
        Preconditions.checkState((boolean)StringUtils.isNotEmpty((String)this.serviceAddress), (String)"No serviceAddress provided in WS consumer config");
        if (this.connectorConfig != null && this.connector != null) {
            throw new ConfigurationException(CoreMessages.createStaticMessage((String)"Cannot set both connector-config and connector-ref attributes. Set either one of them, or none for default behavior."));
        }
        return this.createHttpRequester(flowConstruct);
    }

    private Processor createHttpRequester(final FlowConstruct flowConstruct) throws MuleException {
        return new Processor(){
            private HttpRequestOptions requestOptions;

            public Event process(Event event) throws MuleException {
                ConnectorOperationLocator connectorOperationLocator = (ConnectorOperationLocator)WSConsumerConfig.this.muleContext.getRegistry().get("_muleConnectorMessageProcessorLocator");
                Processor messageProcessor = connectorOperationLocator.locateConnectorOperation(WSConsumerConfig.this.serviceAddress, (OperationOptions)this.getRequestOptions(), MessageExchangePattern.REQUEST_RESPONSE);
                if (messageProcessor instanceof FlowConstructAware) {
                    ((FlowConstructAware)messageProcessor).setFlowConstruct(flowConstruct);
                }
                return messageProcessor.process(event);
            }

            private HttpRequestOptions getRequestOptions() {
                if (this.requestOptions == null) {
                    HttpRequestOptionsBuilder builder = HttpRequestOptionsBuilder.newOptions().method(HttpConstants.Methods.POST.name()).disableStatusCodeValidation().disableParseResponse();
                    if (WSConsumerConfig.this.connectorConfig != null) {
                        builder.requestConfig(WSConsumerConfig.this.connectorConfig);
                    }
                    this.requestOptions = builder.build();
                }
                return this.requestOptions;
            }
        };
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getWsdlLocation() {
        return this.wsdlLocation;
    }

    public void setWsdlLocation(String wsdlLocation) {
        this.wsdlLocation = wsdlLocation;
    }

    public String getService() {
        return this.service;
    }

    public void setService(String service) {
        this.service = service;
    }

    public String getPort() {
        return this.port;
    }

    public void setPort(String port) {
        this.port = port;
    }

    public String getServiceAddress() {
        return this.serviceAddress;
    }

    public void setServiceAddress(String serviceAddress) {
        this.serviceAddress = serviceAddress;
    }

    public LegacyConnector getConnector() {
        return this.connector;
    }

    public void setConnector(LegacyConnector connector) {
        this.connector = connector;
    }

    public HttpRequesterConfig getConnectorConfig() {
        return this.connectorConfig;
    }

    public void setConnectorConfig(HttpRequesterConfig connectorConfig) {
        this.connectorConfig = connectorConfig;
    }

    public WSSecurity getSecurity() {
        return this.security;
    }

    public void setSecurity(WSSecurity security) {
        this.security = security;
    }
}

